/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.SimpleDomainEntity;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;

public class SimpleDomain
extends Summon<SimpleDomainEntity> {
    public SimpleDomain() {
        super(SimpleDomainEntity.class);
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        for (DomainExpansionEntity domain : VeilHandler.getDomains((ServerLevel)owner.m_9236_(), owner.m_20183_())) {
            if (domain.getOwner() == owner) {
                return false;
            }
            if (!domain.hasSureHitEffect()) continue;
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            CursedTechnique ct = cap.getTechnique();
            return ct == null || ct.getDomain() == null || cap.hasBurnout();
        }
        return false;
    }

    @Override
    public boolean canUnlock(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return (!cap.hasTrait(Trait.INCARNATED) || cap.getTechnique() == CursedTechnique.TECHNIQUELESS || (Boolean)ConfigHolder.SERVER.incarnatedSimpleDomain.get() != false) && super.canUnlock(owner);
    }

    @Override
    public boolean isDisplayed(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return (!cap.hasTrait(Trait.INCARNATED) || cap.getTechnique() == CursedTechnique.TECHNIQUELESS || (Boolean)ConfigHolder.SERVER.incarnatedSimpleDomain.get() != false) && super.isDisplayed(owner);
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public List<EntityType<?>> getTypes() {
        return List.of((EntityType)JJKEntities.SIMPLE_DOMAIN.get());
    }

    @Override
    public boolean isTenShadows() {
        return false;
    }

    @Override
    protected SimpleDomainEntity summon(LivingEntity owner) {
        return new SimpleDomainEntity(owner);
    }

    @Override
    public int getCooldown() {
        return 600;
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 1.0f;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.DOMAIN;
    }

    @Override
    public boolean display() {
        return false;
    }

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    @Nullable
    public Ability getParent(LivingEntity owner) {
        return (Ability)JJKAbilities.CURSED_ENERGY_FLOW.get();
    }

    @Override
    public int getPointsCost() {
        return (Integer)ConfigHolder.SERVER.simpleDomainCost.get();
    }

    @Override
    public Vec2 getDisplayCoordinates() {
        return new Vec2(3.0f, 4.0f);
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class SimpleDomainForgeEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            DamageSource damageSource = event.getSource();
            if (!(damageSource instanceof JJKDamageSources.JujutsuDamageSource)) {
                return;
            }
            JJKDamageSources.JujutsuDamageSource jjkdmg = (JJKDamageSources.JujutsuDamageSource)damageSource;
            LivingEntity victim = event.getEntity();
            Ability ability = jjkdmg.getAbility();
            if (ability == null) {
                return;
            }
            if (ability.isTechnique()) {
                for (SimpleDomainEntity simple : victim.m_9236_().m_45976_(SimpleDomainEntity.class, AABB.m_165882_((Vec3)victim.m_20182_(), (double)8.0, (double)8.0, (double)8.0))) {
                    DamageSource source;
                    LivingEntity causingEntity;
                    if (!(victim.m_20270_((Entity)simple) < simple.getRadius()) || (causingEntity = (source = event.getSource()).m_7639_() instanceof LivingEntity ? (LivingEntity)source.m_7639_() : null) == simple.getOwner() || causingEntity == victim) continue;
                    event.setAmount(event.getAmount() * 0.85f);
                    simple.hurt(event.getSource(), event.getAmount() * 1.25f, false);
                }
            }
        }

        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            if (!(event.getSource().m_7640_() instanceof DomainExpansionEntity)) {
                return;
            }
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_ || !JJKAbilities.hasToggled(victim, (Ability)JJKAbilities.SIMPLE_DOMAIN.get())) {
                return;
            }
            ISorcererData cap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            SimpleDomainEntity domain = cap.getSummonByClass(SimpleDomainEntity.class);
            if (domain != null) {
                domain.m_6469_(event.getSource(), event.getAmount());
                event.setCanceled(true);
            }
        }
    }
}

