/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.client.particle.MirageParticle;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class TestDash
extends Ability {
    public static final double RANGE = 80.0;
    private static final float DASH = 2.0f;
    private static final float MAX_DASH = 3.0f;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null) {
            return false;
        }
        return owner.m_142582_((Entity)target) && owner.m_20270_((Entity)target) <= TestDash.getRange((LivingEntity)owner);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        if (!TestDash.canDash(owner)) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    private static boolean canDash(LivingEntity owner) {
        if (owner.m_21023_((MobEffect)JJKEffects.STUN.get())) {
            return false;
        }
        boolean collision = false;
        AABB bounds = owner.m_20191_();
        Cursor3D cursor = new Cursor3D(Mth.m_14107_((double)(bounds.f_82288_ - 1.0E-7)) - 2, Mth.m_14107_((double)(bounds.f_82289_ - 1.0E-7)) - 2, Mth.m_14107_((double)(bounds.f_82290_ - 1.0E-7)) - 2, Mth.m_14107_((double)(bounds.f_82291_ + 1.0E-7)) + 2, Mth.m_14107_((double)(bounds.f_82292_ + 1.0E-7)) + 2, Mth.m_14107_((double)(bounds.f_82293_ + 1.0E-7)) + 2);
        while (cursor.m_122304_()) {
            BlockState state;
            int i = cursor.m_122305_();
            int j = cursor.m_122306_();
            int k = cursor.m_122307_();
            int l = cursor.m_122308_();
            if (l == 3 || (state = owner.m_9236_().m_8055_(new BlockPos(i, j, k))).m_60795_()) continue;
            collision = true;
            break;
        }
        return collision || owner.m_146909_() >= 15.0f;
    }

    private static float getRange(LivingEntity owner) {
        return (float)(80.0 * (double)(JJKAbilities.hasTrait(owner, Trait.HEAVENLY_RESTRICTION) ? 1.5f : 1.0f));
    }

    private Vec3 getTarget(LivingEntity owner) {
        Vec3 start = owner.m_146892_();
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        if (owner instanceof Player) {
            Minecraft instance = Minecraft.m_91087_();
            look = instance.f_91074_.m_20154_().m_82542_(80.0, 0.0, 80.0).m_82541_();
            Vec3 forwards = new Vec3(look.f_82479_, 0.1, look.f_82481_);
            Vec3 backwards = new Vec3(-look.f_82479_, 0.1, -look.f_82481_);
            Vec3 left = new Vec3(look.f_82481_, 0.1, -look.f_82479_);
            Vec3 right = new Vec3(-look.f_82481_, 0.1, look.f_82479_);
            Vec3 forwardsLeft = forwards.m_82549_(left).m_82490_(0.5);
            Vec3 forwardsRight = forwards.m_82549_(right).m_82490_(0.5);
            Vec3 backwardsLeft = backwards.m_82549_(left).m_82490_(0.5);
            Vec3 backwardsRight = backwards.m_82549_(right).m_82490_(0.5);
            look = forwards;
            if (instance.f_91074_.f_108618_.f_108566_ > 0.0f && instance.f_91074_.f_108618_.f_108567_ > 0.0f) {
                look = forwardsLeft;
            } else if (instance.f_91074_.f_108618_.f_108566_ < 0.0f && instance.f_91074_.f_108618_.f_108567_ > 0.0f) {
                look = forwardsRight;
            } else if (instance.f_91074_.f_108618_.f_108566_ > 0.0f && instance.f_91074_.f_108618_.f_108567_ < 0.0f) {
                look = backwardsLeft;
            } else if (instance.f_91074_.f_108618_.f_108566_ < 0.0f && instance.f_91074_.f_108618_.f_108567_ < 0.0f) {
                look = backwardsRight;
            } else if (instance.f_91074_.f_108618_.f_108566_ > 0.0f) {
                look = left;
            } else if (instance.f_91074_.f_108618_.f_108566_ < 0.0f) {
                look = right;
            } else if (instance.f_91074_.f_108618_.f_108567_ < 0.0f) {
                look = backwards;
            }
        }
        return look;
    }

    @Override
    public void run(LivingEntity owner) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!TestDash.canDash(owner)) {
            return;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.getSpeedStacks() > 0 || cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
            owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)JJKSounds.DASH.get(), SoundSource.MASTER, 1.0f, 1.0f);
            owner.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.INVISIBILITY.get(), 5, 0, false, false, false));
            level2.m_8767_((ParticleOptions)new MirageParticle.MirageParticleOptions(owner.m_19879_()), owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), 0, 0.0, 0.0, 0.0, 1.0);
        }
        HitResult hit = RotationUtil.getLookAtHit((Entity)owner, TestDash.getRange(owner));
        float power = Math.min(3.0f, 2.0f * (1.0f + this.getPower(owner) * 0.1f));
        Vec3 target = this.getTarget(owner);
        Vec3 velocity = target.m_82541_().m_82490_((double)power);
        Vec3 look = target;
        velocity = velocity.m_82559_(new Vec3(0.7, 1.0, 0.7));
        if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
            velocity = velocity.m_82559_(new Vec3(1.2, 1.0, 1.2)).m_82549_(new Vec3(0.0, 0.05, 0.0));
        }
        velocity = velocity.m_82549_(new Vec3(0.0, 0.2, 0.0));
        if (!owner.m_20096_() && owner.m_9236_().m_8055_(owner.m_20183_()).m_60819_().m_76178_()) {
            velocity = velocity.m_82549_(new Vec3(0.0, -0.75, 0.0));
        }
        owner.m_20256_(velocity);
        owner.f_19864_ = true;
        Vec3 pos = owner.m_20182_();
        for (int i = 0; i < 32; ++i) {
            double xPos = owner.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.25f) - owner.m_20154_().m_82490_((double)0.35).f_82479_;
            double yPos = owner.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)owner.m_20206_();
            double zPos = owner.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.25f) - owner.m_20154_().m_82490_((double)0.35).f_82481_;
            double theta = HelperMethods.RANDOM.m_188500_() * 2.0 * Math.PI;
            double phi = HelperMethods.RANDOM.m_188500_() * Math.PI;
            double r = HelperMethods.RANDOM.m_188500_() * 0.2;
            double x = r * Math.sin(phi) * Math.cos(theta);
            double y = r * Math.sin(phi) * Math.sin(theta);
            double z = r * Math.cos(phi);
            Vec3 speed = look.m_82520_(x, y, z).m_82548_();
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123796_, xPos, yPos, zPos, 0, speed.f_82479_, speed.f_82480_, speed.f_82481_, 1.0);
        }
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        ISorcerer sorcerer;
        return (!(owner instanceof ISorcerer) || (sorcerer = (ISorcerer)owner).canJump()) && super.isValid(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 0.0f;
    }

    @Override
    public int getCooldown() {
        return 10;
    }

    @Override
    public int getRealCooldown(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
            return 4;
        }
        return super.getRealCooldown(owner);
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.NONE;
    }
}

