/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc.lightning;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedEnergyNature;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.EmittingLightningParticle;
import radon.jujutsu_kaisen.client.particle.LightningParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;

public class Discharge
extends Ability
implements Ability.IChannelened,
Ability.IDurationable {
    private static final float DAMAGE = 12.0f;
    private static final float MAX_RADIUS = 20.0f;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || target.m_21224_() || !owner.m_142582_((Entity)target) || owner.m_20270_((Entity)target) > this.getRadius((LivingEntity)owner) / 2.0f) {
            return false;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getType() == JujutsuType.CURSE || cap.isUnlocked((Ability)JJKAbilities.RCT1.get()) ? owner.m_21223_() / owner.m_21233_() < 0.9f : owner.m_21223_() / owner.m_21233_() < 0.4f;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    private float getRadius(LivingEntity owner) {
        return Math.min(20.0f, this.getPower(owner) * 4.0f);
    }

    @Override
    public void run(LivingEntity owner) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)JJKSounds.ELECTRICITY.get(), SoundSource.MASTER, 3.0f, 1.0f);
        float radius = this.getRadius(owner);
        for (int i = 0; i < 4; ++i) {
            level2.m_8767_((ParticleOptions)new EmittingLightningParticle.EmittingLightningParticleOptions(ParticleColors.getCursedEnergyColorBright(owner), radius, 1), owner.m_20185_(), owner.m_20186_() + (double)(owner.m_20206_() / 2.0f), owner.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
        }
        for (Entity entity : owner.m_9236_().m_45933_((Entity)owner, AABB.m_165882_((Vec3)owner.m_20182_(), (double)radius, (double)radius, (double)radius))) {
            if (!entity.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, this), 12.0f * this.getPower(owner))) continue;
            for (int i = 0; i < 4; ++i) {
                double x = entity.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(entity.m_20205_() * 2.0f);
                double y = entity.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)(entity.m_20206_() * 1.25f);
                double z = entity.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(entity.m_20205_() * 2.0f);
                level2.m_8767_((ParticleOptions)new LightningParticle.LightningParticleOptions(ParticleColors.getCursedEnergyColorBright(owner), 0.2f, 1), x, y, z, 0, 0.0, 0.0, 0.0, 0.0);
            }
            owner.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)JJKSounds.ELECTRICITY.get(), SoundSource.MASTER, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getNature() == CursedEnergyNature.LIGHTNING && JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.CURSED_ENERGY_FLOW.get()) && super.isValid(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 10.0f;
    }

    @Override
    public int getDuration() {
        return 5;
    }

    @Override
    public int getCooldown() {
        return 200;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.LIGHTNING;
    }
}

