/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.projection_sorcery;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.effect.ProjectionFrameEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.ScreenFlashS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;

public class TwentyFourFrameRule
extends Ability
implements Ability.IToggled,
Ability.IAttack {
    private static final float DAMAGE = 11.0f;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return true;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public void run(LivingEntity owner) {
    }

    @Override
    public int getCooldown() {
        return 100;
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 100.0f;
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    @Override
    public boolean attack(DamageSource source, LivingEntity owner, LivingEntity target) {
        if (owner.m_9236_().f_46443_) {
            return false;
        }
        if (!HelperMethods.isMelee(source)) {
            return false;
        }
        for (ProjectionFrameEntity frame : owner.m_9236_().m_45976_(ProjectionFrameEntity.class, AABB.m_165882_((Vec3)target.m_20182_(), (double)8.0, (double)8.0, (double)8.0))) {
            if (frame.getVictim() != target) continue;
            return false;
        }
        owner.m_9236_().m_7967_((Entity)new ProjectionFrameEntity(owner, target, Ability.getPower((Ability)JJKAbilities.TWENTY_FOUR_FRAME_RULE.get(), owner)));
        if (target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            PacketHandler.sendToClient(new ScreenFlashS2CPacket(), player);
        }
        return true;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.PROJECTION;
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class TwentyFourFrameRuleForgeEvents {
        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            DamageSource source = event.getSource();
            Entity entity = source.m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            for (ProjectionFrameEntity frame : victim.m_9236_().m_45976_(ProjectionFrameEntity.class, AABB.m_165882_((Vec3)victim.m_20182_(), (double)8.0, (double)8.0, (double)8.0))) {
                if (frame.getVictim() != victim) continue;
                Vec3 center = new Vec3(frame.m_20185_(), frame.m_20186_(), frame.m_20189_());
                ((ServerLevel)frame.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, center.f_82479_, center.f_82480_, center.f_82481_, 0, 1.0, 0.0, 0.0, 1.0);
                frame.m_9236_().m_6263_(null, frame.m_20185_(), frame.m_20186_(), frame.m_20189_(), SoundEvents.f_11913_, SoundSource.MASTER, 1.0f, 1.0f);
                frame.m_9236_().m_6263_(null, frame.m_20185_(), frame.m_20186_(), frame.m_20189_(), SoundEvents.f_11983_, SoundSource.MASTER, 1.0f, 1.0f);
                frame.m_146870_();
                LivingEntity owner = frame.getOwner();
                if (owner == null) continue;
                if (!victim.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack(frame, attacker, (Ability)JJKAbilities.TWENTY_FOUR_FRAME_RULE.get()), 11.0f * frame.getPower()) || !victim.m_21224_()) break;
                event.setCanceled(true);
                break;
            }
        }
    }
}

