/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.ratio;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;

public class RatioRule
extends Ability
implements Ability.IAttack,
Ability.IToggled {
    private static final float MAX_DAMAGE = 40.0f;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.addBlackFlash()) {
            return target != null && !target.m_21224_() && (double)owner.m_20270_((Entity)target) <= 40.0;
        }
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public void run(LivingEntity owner) {
    }

    private float calculateDamage(DamageSource source, LivingEntity owner, LivingEntity target) {
        float damage = target.m_21233_();
        float armor = target.m_21230_();
        float toughness = (float)target.m_21133_(Attributes.f_22285_);
        float f = 2.0f + toughness / 4.0f;
        float f1 = Mth.m_14036_((float)(armor - damage / f), (float)(armor * 0.2f), (float)20.0f);
        damage /= 1.0f - f1 / 25.0f;
        MobEffectInstance instance = target.m_21124_(MobEffects.f_19606_);
        if (instance != null) {
            int resistance = instance.m_19564_();
            int i = (resistance + 1) * 5;
            int j = 25 - i;
            if (j == 0) {
                return damage;
            }
            float x = 25.0f / (float)j;
            damage *= x;
        }
        return damage * 0.5f;
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 200.0f;
    }

    @Override
    public boolean attack(DamageSource source, LivingEntity owner, LivingEntity target) {
        if (owner.m_9236_().f_46443_) {
            return false;
        }
        if (!HelperMethods.isMelee(source)) {
            return false;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.addBlackFlash()) {
            ((ServerLevel)owner.m_9236_()).m_7726_().m_8394_((Entity)owner, (Packet)new ClientboundAnimatePacket((Entity)target, 4));
            target.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, (Ability)JJKAbilities.RATIO_RULE.get()), this.calculateDamage(source, owner, target) * (this.getPower(owner) * 0.15f));
            owner.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)JJKSounds.RATIO_RULE.get(), SoundSource.MASTER, 1.0f, 1.1f);
            return true;
        }
        return false;
    }

    @Override
    public int getCooldown() {
        return 200;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.SLASHING;
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }
}

