/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.sky_strike;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.entity.effect.SkyStrikeEntity;
import radon.jujutsu_kaisen.util.RotationUtil;

public class SkyStrike
extends Ability {
    public static final double RANGE = 50.0;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return target != null && this.getTarget((LivingEntity)owner) == target;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Nullable
    private LivingEntity getTarget(LivingEntity owner) {
        EntityHitResult hit;
        HitResult hitResult = RotationUtil.getLookAtHit((Entity)owner, 50.0);
        if (hitResult instanceof EntityHitResult && (hitResult = (hit = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)hitResult;
            if (!owner.m_6779_(target)) {
                return null;
            }
            return target;
        }
        return null;
    }

    @Override
    public void run(LivingEntity owner) {
        LivingEntity target;
        if (owner instanceof Player) {
            owner.m_6674_(InteractionHand.MAIN_HAND);
        }
        if ((target = this.getTarget(owner)) == null) {
            return;
        }
        SkyStrikeEntity strike = new SkyStrikeEntity(owner, this.getPower(owner), target.m_20182_());
        owner.m_9236_().m_7967_((Entity)strike);
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        LivingEntity target = this.getTarget(owner);
        if (target == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public int getCooldown() {
        return 40;
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 100.0f;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

