/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.block;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.block.JJKBlocks;
import radon.jujutsu_kaisen.block.entity.DisplayCaseBlockEntity;
import radon.jujutsu_kaisen.block.entity.JJKBlockEntities;
import radon.jujutsu_kaisen.item.base.CursedObjectItem;

public class DisplayCaseBlock
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Stream.of(Shapes.m_83113_((VoxelShape)Block.m_49796_((double)6.875, (double)14.024999999999988, (double)8.0, (double)9.125, (double)15.524999999999988, (double)8.0), (VoxelShape)Shapes.m_83113_((VoxelShape)Block.m_49796_((double)6.5, (double)13.424999999999994, (double)6.5, (double)9.5, (double)14.17499999999999, (double)9.5), (VoxelShape)Shapes.m_83113_((VoxelShape)Block.m_49796_((double)6.5625, (double)12.587499999999991, (double)6.5625, (double)9.4375, (double)13.212499999999988, (double)9.4375), (VoxelShape)Block.m_49796_((double)8.0, (double)14.024999999999988, (double)6.875, (double)8.0, (double)15.524999999999988, (double)9.125), (BooleanOp)BooleanOp.f_82689_), (BooleanOp)BooleanOp.f_82689_), (BooleanOp)BooleanOp.f_82689_), Block.m_49796_((double)1.875, (double)1.2249999999999992, (double)1.875, (double)14.125, (double)13.47499999999999, (double)14.125), Block.m_49796_((double)2.0, (double)4.163336342344337E-17, (double)2.0, (double)14.0, (double)1.5, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public DisplayCaseBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        if (pHand == InteractionHand.MAIN_HAND && pPlayer instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pPlayer;
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof DisplayCaseBlockEntity) {
                DisplayCaseBlockEntity be = (DisplayCaseBlockEntity)blockEntity;
                ItemStack stack = player.m_21120_(pHand);
                if (stack.m_41720_() instanceof CursedObjectItem) {
                    if (be.getItem().m_41619_()) {
                        ItemStack copy = stack.m_41777_();
                        be.setItem(copy);
                        if (!player.m_150110_().f_35937_) {
                            stack.m_41774_(1);
                        }
                        return InteractionResult.CONSUME;
                    }
                } else if (!be.getItem().m_41619_() && !player.m_150110_().f_35937_ && player.m_36356_(be.getItem())) {
                    be.setItem(ItemStack.f_41583_);
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new DisplayCaseBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return JJKBlocks.createTickerHelper(pBlockEntityType, (BlockEntityType)JJKBlockEntities.DISPLAY_CASE.get(), DisplayCaseBlockEntity::tick);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }
}

