/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.block.entity;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.block.JJKBlocks;
import radon.jujutsu_kaisen.block.entity.JJKBlockEntities;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.item.base.CursedObjectItem;
import radon.jujutsu_kaisen.tags.JJKEntityTypeTags;
import radon.jujutsu_kaisen.util.HelperMethods;

public class DisplayCaseBlockEntity
extends BlockEntity {
    private static final int SPAWN_RANGE = 8;
    private ItemStack stack = ItemStack.f_41583_;
    private int rot = 0;

    public DisplayCaseBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)JJKBlockEntities.DISPLAY_CASE.get(), pPos, pBlockState);
    }

    @Nullable
    private static Entity getRandomCurse(Level level, float energy) {
        ArrayList<LivingEntity> pool = new ArrayList<LivingEntity>();
        for (EntityType type : level.m_9598_().m_175515_(Registries.f_256939_)) {
            ISorcerer sorcerer;
            LivingEntity entity;
            Entity entity2;
            if (!type.m_204039_(JJKEntityTypeTags.SPAWNABLE_CURSE) || !((entity2 = type.m_20615_(level)) instanceof LivingEntity) || !((entity = (LivingEntity)entity2) instanceof ISorcerer) || !((sorcerer = (ISorcerer)entity).getExperience() <= energy)) continue;
            pool.add(entity);
        }
        return pool.isEmpty() ? null : (Entity)pool.get(HelperMethods.RANDOM.m_188503_(pool.size()));
    }

    public boolean hasItem() {
        Item item = this.stack.m_41720_();
        if (item instanceof CursedObjectItem) {
            CursedObjectItem obj = (CursedObjectItem)item;
            return true;
        }
        return false;
    }

    public float getEnergy() {
        Item item = this.stack.m_41720_();
        if (item instanceof CursedObjectItem) {
            CursedObjectItem obj = (CursedObjectItem)item;
            int index = obj.getGrade().ordinal();
            return SorcererGrade.values()[index].getRequiredExperience();
        }
        return 0.0f;
    }

    private static boolean isRightDistanceToPlayerAndSpawnPoint(ServerLevel pLevel, ChunkAccess pChunk, BlockPos.MutableBlockPos pPos, double pDistance) {
        if (pDistance <= 576.0) {
            return false;
        }
        if (pLevel.m_220360_().m_203195_((Position)new Vec3((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_(), (double)pPos.m_123343_() + 0.5), 24.0)) {
            return false;
        }
        return Objects.equals(new ChunkPos((BlockPos)pPos), pChunk.m_7697_()) || pLevel.m_201918_((BlockPos)pPos);
    }

    private static boolean isValidSpawnPostitionForType(ServerLevel pLevel, MobCategory pCategory, StructureManager pStructureManager, ChunkGenerator pGenerator, MobSpawnSettings.SpawnerData pData, BlockPos.MutableBlockPos pPos, double pDistance) {
        EntityType type = pData.f_48404_;
        if (type.m_20674_() == MobCategory.MISC) {
            return false;
        }
        if (!type.m_20673_() && pDistance > (double)(type.m_20674_().m_21611_() * type.m_20674_().m_21611_())) {
            return false;
        }
        if (type.m_20654_() && DisplayCaseBlockEntity.canSpawnMobAt(pLevel, pStructureManager, pGenerator, pCategory, pData, (BlockPos)pPos)) {
            SpawnPlacements.Type spawn = SpawnPlacements.m_21752_((EntityType)type);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)spawn, (LevelReader)pLevel, (BlockPos)pPos, (EntityType)type)) {
                return false;
            }
            if (!SpawnPlacements.m_217074_((EntityType)type, (ServerLevelAccessor)pLevel, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)pPos, (RandomSource)HelperMethods.RANDOM)) {
                return false;
            }
            return pLevel.m_45772_(type.m_20585_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_(), (double)pPos.m_123343_() + 0.5));
        }
        return false;
    }

    private static boolean isValidPositionForMob(ServerLevel pLevel, Mob pMob, double pDistance) {
        if (pDistance > (double)(pMob.m_6095_().m_20674_().m_21611_() * pMob.m_6095_().m_20674_().m_21611_()) && pMob.m_6785_(pDistance)) {
            return false;
        }
        return ForgeEventFactory.checkSpawnPosition((Mob)pMob, (ServerLevelAccessor)pLevel, (MobSpawnType)MobSpawnType.SPAWNER);
    }

    private static Optional<MobSpawnSettings.SpawnerData> getRandomSpawnMobAt(ServerLevel pLevel, StructureManager pStructureManager, ChunkGenerator pGenerator, MobCategory pCategory, RandomSource pRandom, BlockPos pPos) {
        Holder holder = pLevel.m_204166_(pPos);
        return pCategory == MobCategory.WATER_AMBIENT && holder.m_203656_(BiomeTags.f_215811_) && pRandom.m_188501_() < 0.98f ? Optional.empty() : DisplayCaseBlockEntity.mobsAt(pLevel, pStructureManager, pGenerator, pCategory, pPos, (Holder<Biome>)holder).m_216829_(pRandom);
    }

    private static WeightedRandomList<MobSpawnSettings.SpawnerData> mobsAt(ServerLevel pLevel, StructureManager pStructureManager, ChunkGenerator pGenerator, MobCategory pCategory, BlockPos pPos, @javax.annotation.Nullable Holder<Biome> pBiome) {
        return ForgeEventFactory.getPotentialSpawns((LevelAccessor)pLevel, (MobCategory)pCategory, (BlockPos)pPos, (WeightedRandomList)(NaturalSpawner.m_220455_((BlockPos)pPos, (ServerLevel)pLevel, (MobCategory)pCategory, (StructureManager)pStructureManager) ? ((StructureSpawnOverride)((Structure)pStructureManager.m_220521_().m_175515_(Registries.f_256944_).m_123013_(BuiltinStructures.f_209859_)).m_226612_().get(MobCategory.MONSTER)).f_210044_() : pGenerator.m_223133_(pBiome != null ? pBiome : pLevel.m_204166_(pPos), pStructureManager, pCategory, pPos)));
    }

    private static boolean canSpawnMobAt(ServerLevel pLevel, StructureManager pStructureManager, ChunkGenerator pGenerator, MobCategory pCategory, MobSpawnSettings.SpawnerData pData, BlockPos pPos) {
        return DisplayCaseBlockEntity.mobsAt(pLevel, pStructureManager, pGenerator, pCategory, pPos, null).m_146338_().contains(pData);
    }

    private static BlockPos getRandomPosWithin(Level pLevel, LevelChunk pChunk, BlockPos center, int yRange) {
        ChunkPos chunkPos = pChunk.m_7697_();
        int i = chunkPos.m_45604_() + HelperMethods.RANDOM.m_188503_(16);
        int j = chunkPos.m_45605_() + HelperMethods.RANDOM.m_188503_(16);
        int minY = Math.max(pLevel.m_141937_(), center.m_123342_() - yRange);
        int maxY = Math.min(pLevel.m_151558_(), center.m_123342_() + yRange);
        int l = HelperMethods.RANDOM.m_188503_(maxY - minY + 1) + minY;
        return new BlockPos(i, l, j);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, DisplayCaseBlockEntity pBlockEntity) {
        Entity z2;
        pBlockEntity.rotTick();
        if (pLevel.f_46443_) {
            return;
        }
        float energy = pBlockEntity.getEnergy();
        int centerX = pPos.m_123341_() >> 4;
        int centerZ = pPos.m_123343_() >> 4;
        int displayCaseCount = 0;
        for (int x = centerX - 1; x <= centerX + 1; ++x) {
            for (int z2 = centerZ - 1; z2 <= centerZ + 1; ++z2) {
                LevelChunk chunk = pLevel.m_6325_(x, z2);
                for (BlockPos pos : chunk.m_5928_()) {
                    DisplayCaseBlockEntity be;
                    BlockEntity blockEntity;
                    BlockState state;
                    if (pos.equals((Object)pPos) || !(state = pLevel.m_8055_(pos)).m_60713_((Block)JJKBlocks.DISPLAY_CASE.get()) || !((blockEntity = pLevel.m_7702_(pos)) instanceof DisplayCaseBlockEntity) || !(be = (DisplayCaseBlockEntity)blockEntity).hasItem()) continue;
                    ++displayCaseCount;
                }
            }
        }
        if (displayCaseCount >= 5) {
            return;
        }
        if (!pBlockEntity.hasItem() || !((z2 = DisplayCaseBlockEntity.getRandomCurse(pLevel, energy)) instanceof CursedSpirit)) {
            return;
        }
        CursedSpirit curse = (CursedSpirit)z2;
        int rng = 64 * Math.max(1, Mth.m_14143_((float)((Integer)ConfigHolder.SERVER.displayCaseSpawnRate.get()).intValue()) / (pLevel.m_46462_() ? 4 : 3));
        if (HelperMethods.RANDOM.m_188503_(rng) != 0) {
            return;
        }
        EntityType type = curse.m_6095_();
        float radius = ((Integer)ConfigHolder.SERVER.displayCaseSpawnRange.get()).intValue();
        float offsetX = (HelperMethods.RANDOM.m_188501_() - 0.5f) * radius;
        float offsetZ = (HelperMethods.RANDOM.m_188501_() - 0.5f) * radius;
        int spawnCenterX = pPos.m_123341_();
        int spawnCenterZ = pPos.m_123343_();
        int spawnX = (int)((float)spawnCenterX + offsetX);
        int spawnZ = (int)((float)spawnCenterZ + offsetZ);
        BlockPos pos = new BlockPos(spawnX, pPos.m_123342_(), spawnZ);
        if (pos.m_123342_() < pLevel.m_141937_() + 1) {
            return;
        }
        ChunkAccess chunk = pLevel.m_46865_(pos);
        StructureManager manager = ((ServerLevel)pLevel).m_215010_();
        ChunkGenerator generator = ((ServerLevel)pLevel).m_7726_().m_8481_();
        int i = pos.m_123342_();
        BlockState state = chunk.m_8055_(pos);
        if (!state.m_60796_((BlockGetter)chunk, pos)) {
            BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
            int j = 0;
            block3: for (int k = 0; k < 3; ++k) {
                int l = pos.m_123341_();
                int i1 = pos.m_123343_();
                int j1 = 6;
                MobSpawnSettings.SpawnerData spawn = null;
                SpawnGroupData group = null;
                int k1 = Mth.m_14167_((float)(HelperMethods.RANDOM.m_188501_() * 4.0f));
                int l1 = 0;
                for (int i2 = 0; i2 < k1; ++i2) {
                    double d2;
                    mut.m_122178_(l += HelperMethods.RANDOM.m_188503_(j1) - HelperMethods.RANDOM.m_188503_(j1), i, i1 += HelperMethods.RANDOM.m_188503_(j1) - HelperMethods.RANDOM.m_188503_(j1));
                    double d0 = (double)l + 0.5;
                    double d1 = (double)i1 + 0.5;
                    Player player = pLevel.m_45924_(d0, (double)i, d1, -1.0, false);
                    if (player == null || !DisplayCaseBlockEntity.isRightDistanceToPlayerAndSpawnPoint((ServerLevel)pLevel, chunk, mut, d2 = player.m_20275_(d0, (double)i, d1))) continue;
                    if (spawn == null) {
                        Optional<MobSpawnSettings.SpawnerData> optional = DisplayCaseBlockEntity.getRandomSpawnMobAt((ServerLevel)pLevel, manager, generator, type.m_20674_(), HelperMethods.RANDOM, (BlockPos)mut);
                        if (optional.isEmpty()) continue block3;
                        spawn = optional.get();
                        k1 = spawn.f_48405_ + HelperMethods.RANDOM.m_188503_(1 + spawn.f_48406_ - spawn.f_48405_);
                    }
                    if (!DisplayCaseBlockEntity.isValidSpawnPostitionForType((ServerLevel)pLevel, type.m_20674_(), manager, generator, spawn, mut, d2)) continue;
                    curse.m_7678_(d0, i, d1, HelperMethods.RANDOM.m_188501_() * 360.0f, 0.0f);
                    if (!DisplayCaseBlockEntity.isValidPositionForMob((ServerLevel)pLevel, (Mob)curse, d2)) continue;
                    group = curse.m_6518_((ServerLevelAccessor)pLevel, pLevel.m_6436_(curse.m_20183_()), MobSpawnType.SPAWNER, group, null);
                    ++l1;
                    ((ServerLevel)pLevel).m_47205_((Entity)curse);
                    if (++j >= ForgeEventFactory.getMaxSpawnPackSize((Mob)curse)) {
                        return;
                    }
                    if (curse.m_7296_(l1)) continue block3;
                }
            }
        }
    }

    public void rotTick() {
        if (this.rot != Short.MIN_VALUE) {
            ++this.rot;
        }
    }

    public int getRot() {
        return this.rot;
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public void setItem(ItemStack stack) {
        this.stack = stack;
        this.stack.m_41764_(1);
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
        this.m_6596_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("rotation", this.rot);
        pTag.m_128365_("stack", (Tag)this.stack.m_41739_(new CompoundTag()));
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.rot = pTag.m_128451_("rotation");
        this.stack = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("stack"));
    }
}

