/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.block.entity.JJKBlockEntities;

public class DurationBlockEntity
extends BlockEntity {
    private boolean initialized;
    private int duration;
    @Nullable
    private BlockState original;
    private CompoundTag deferred;

    public DurationBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public DurationBlockEntity(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)JJKBlockEntities.DURATION.get(), pPos, pBlockState);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, DurationBlockEntity pBlockEntity) {
        if (--pBlockEntity.duration <= 0) {
            BlockState original = pBlockEntity.getOriginal();
            if (original != null) {
                if (original.m_60795_()) {
                    pLevel.m_46597_(pPos, Blocks.f_50016_.m_49966_());
                } else {
                    pLevel.m_46597_(pPos, original);
                }
            } else {
                pLevel.m_46597_(pPos, Blocks.f_50016_.m_49966_());
            }
        }
    }

    @Nullable
    public BlockState getOriginal() {
        if (this.original == null && this.deferred != null) {
            this.original = NbtUtils.m_247651_((HolderGetter)this.f_58857_.m_246945_(Registries.f_256747_), (CompoundTag)this.deferred);
            this.deferred = null;
            this.m_6596_();
        }
        return this.original;
    }

    public void setDuration(int duration) {
        this.duration = duration;
        this.m_6596_();
    }

    public void create(int duration, BlockState state) {
        this.initialized = true;
        this.duration = duration;
        this.original = state;
        this.m_6596_();
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.initialized = pTag.m_128471_("initialized");
        if (this.initialized) {
            this.duration = pTag.m_128451_("duration");
            this.deferred = pTag.m_128469_("original");
        }
    }

    public void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128379_("initialized", this.initialized);
        if (this.initialized) {
            pTag.m_128405_("duration", this.duration);
            if (this.original != null) {
                pTag.m_128365_("original", (Tag)NbtUtils.m_129202_((BlockState)this.original));
            } else {
                pTag.m_128365_("original", (Tag)this.deferred);
            }
        }
    }
}

