/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.capability.data.ten_shadows;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;

public class Adaptation {
    private final ResourceLocation key;
    @Nullable
    private Ability ability;

    public Adaptation(ResourceLocation key) {
        this.key = key;
    }

    public Adaptation(ResourceLocation key, @Nullable Ability ability) {
        this(key);
        this.ability = ability;
    }

    public Adaptation(CompoundTag nbt) {
        this.key = new ResourceLocation(nbt.m_128461_("name"));
        if (nbt.m_128441_("technique")) {
            this.ability = JJKAbilities.getValue(new ResourceLocation(nbt.m_128461_("technique")));
        }
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    @Nullable
    public Ability getAbility() {
        return this.ability;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("ability", this.key.toString());
        if (this.ability != null) {
            nbt.m_128359_("technique", JJKAbilities.getKey(this.ability).toString());
        }
        return nbt;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Adaptation)) {
            return false;
        }
        Adaptation other = (Adaptation)obj;
        if (this.ability != null && other.ability != null) {
            Ability.Classification first = this.ability.getClassification();
            Ability.Classification second = other.ability.getClassification();
            return this.ability == other.ability || first != Ability.Classification.NONE && first == second;
        }
        return this.key == other.key;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.ability != null) {
            Ability.Classification classification = this.ability.getClassification();
            result = 31 * result + (classification == Ability.Classification.NONE ? this.ability.hashCode() : classification.hashCode());
        }
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public static enum Type {
        DAMAGE,
        COUNTER;

    }
}

