/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.overlay;

import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.util.HelperMethods;

@Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class BlinkOverlay {
    private static FlashEvent current;
    private static ChatVisiblity previousChatVisibility;
    public static IGuiOverlay OVERLAY;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (current == null) {
            return;
        }
        --BlinkOverlay.current.duration;
        if (BlinkOverlay.current.duration <= 0) {
            current = null;
            if (previousChatVisibility != null) {
                Minecraft mc = Minecraft.m_91087_();
                mc.f_91066_.m_232090_().m_231514_((Object)previousChatVisibility);
                previousChatVisibility = null;
            }
        }
    }

    public static void flash(int setDuration) {
        Minecraft mc = Minecraft.m_91087_();
        if (current == null) {
            previousChatVisibility = (ChatVisiblity)mc.f_91066_.m_232090_().m_231551_();
            mc.f_91066_.m_232090_().m_231514_((Object)ChatVisiblity.HIDDEN);
        }
        current = new FlashEvent(setDuration);
    }

    static {
        OVERLAY = (gui, graphics, partialTicks, width, height) -> {
            if (current == null) {
                return;
            }
            float alpha = (float)BlinkOverlay.current.duration / (float)BlinkOverlay.current.maxDuration;
            alpha = (double)alpha >= 0.5 ? 1.0f : (alpha *= 2.0f);
            graphics.m_280509_(0, 0, width, height, HelperMethods.toRGB24(0, 0, 0, (int)(255.0f * alpha)));
        };
    }

    public static class FlashEvent {
        public int duration;
        public int maxDuration;

        public FlashEvent(int duration) {
            this.duration = duration;
            this.maxDuration = duration;
        }
    }
}

