/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.c2s.ShadowInventoryTakeC2SPacket;
import radon.jujutsu_kaisen.util.HelperMethods;

public class ShadowInventoryScreen
extends Screen {
    private static final int RADIUS_IN = 50;
    private static final int RADIUS_OUT = 100;
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    private int hovered = -1;

    public ShadowInventoryScreen() {
        super(Component.m_130674_(null));
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ == null) {
            return;
        }
        List<ItemStack> inventory = this.getItems();
        if (inventory == null) {
            return;
        }
        this.items.addAll(inventory);
        if (this.items.isEmpty()) {
            this.m_7379_();
        }
    }

    @Nullable
    private List<ItemStack> getItems() {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return null;
        }
        if (!this.f_96541_.f_91074_.getCapability(TenShadowsDataHandler.INSTANCE).isPresent()) {
            return null;
        }
        ITenShadowsData cap = (ITenShadowsData)this.f_96541_.f_91074_.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getShadowInventory();
    }

    private void drawSlot(PoseStack poseStack, BufferBuilder buffer, float centerX, float centerY, float startAngle, float endAngle, int color) {
        float angle = endAngle - startAngle;
        float precision = 0.0069444445f;
        int sections = Math.max(1, Mth.m_14167_((float)(angle / precision)));
        angle = endAngle - startAngle;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int a = color >> 24 & 0xFF;
        float slice = angle / (float)sections;
        for (int i = 0; i < sections; ++i) {
            float angle1 = startAngle + (float)i * slice;
            float angle2 = startAngle + (float)(i + 1) * slice;
            float x1 = centerX + 50.0f * (float)Math.cos(angle1);
            float y1 = centerY + 50.0f * (float)Math.sin(angle1);
            float x2 = centerX + 100.0f * (float)Math.cos(angle1);
            float y2 = centerY + 100.0f * (float)Math.sin(angle1);
            float x3 = centerX + 100.0f * (float)Math.cos(angle2);
            float y3 = centerY + 100.0f * (float)Math.sin(angle2);
            float x4 = centerX + 50.0f * (float)Math.cos(angle2);
            float y4 = centerY + 50.0f * (float)Math.sin(angle2);
            Matrix4f pose = poseStack.m_85850_().m_252922_();
            buffer.m_252986_(pose, x2, y2, 0.0f).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(pose, x1, y1, 0.0f).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(pose, x4, y4, 0.0f).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(pose, x3, y3, 0.0f).m_6122_(r, g, b, a).m_5752_();
        }
    }

    public void m_7379_() {
        if (this.hovered != -1) {
            PacketHandler.sendToServer(new ShadowInventoryTakeC2SPacket(this.hovered));
        }
        super.m_7379_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hovered != -1) {
            PacketHandler.sendToServer(new ShadowInventoryTakeC2SPacket(this.hovered));
            this.items.remove(this.hovered);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public static void drawCenteredString(@NotNull GuiGraphics pGuiGraphics, Font pFont, Component pText, int pX, int pY, int pColor) {
        FormattedCharSequence sql = pText.m_7532_();
        pGuiGraphics.m_280648_(pFont, sql, pX - pFont.m_92724_(sql) / 2, pY, pColor);
    }

    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTicks);
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pGuiGraphics.m_280168_().m_85836_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < this.items.size(); ++i) {
            float startAngle = this.getAngleFor((float)i - 0.5f);
            float endAngle = this.getAngleFor((float)i + 0.5f);
            int white = HelperMethods.toRGB24(255, 255, 255, 150);
            int black = HelperMethods.toRGB24(0, 0, 0, 150);
            this.drawSlot(pGuiGraphics.m_280168_(), buffer, centerX, centerY, startAngle, endAngle, this.hovered == i ? white : black);
        }
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        pGuiGraphics.m_280168_().m_85849_();
        float radius = 75.0f;
        for (int i = 0; i < this.items.size(); ++i) {
            float start = this.getAngleFor((float)i - 0.5f);
            float end = this.getAngleFor((float)i + 0.5f);
            float middle = (start + end) / 2.0f;
            int posX = (int)((float)centerX + radius * (float)Math.cos(middle));
            int posY = (int)((float)centerY + radius * (float)Math.sin(middle));
            ItemStack stack = this.items.get(i);
            if (this.hovered == i) {
                int x = this.f_96543_ / 2;
                int n = this.f_96544_ / 2;
                Objects.requireNonNull(this.f_96547_);
                int y = n - 9 / 2;
                ShadowInventoryScreen.drawCenteredString(pGuiGraphics, this.f_96547_, stack.m_41786_(), x, y, 0xFFFFFF);
            }
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_(-8.0f, -8.0f, 0.0f);
            pGuiGraphics.m_280203_(stack, posX, posY);
            pGuiGraphics.m_280370_(this.f_96547_, stack, posX, posY);
            pGuiGraphics.m_280168_().m_85849_();
        }
    }

    public void m_94757_(double pMouseX, double pMouseY) {
        double mouseAngle;
        super.m_94757_(pMouseX, pMouseY);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        double mousePos = Math.sqrt(Math.pow(pMouseX - (double)centerX, 2.0) + Math.pow(pMouseY - (double)centerY, 2.0));
        if (this.items.size() > 0) {
            float startAngle = this.getAngleFor(-0.5);
            float endAngle = this.getAngleFor((float)this.items.size() - 0.5f);
            for (mouseAngle = Math.atan2(pMouseY - (double)centerY, pMouseX - (double)centerX); mouseAngle < (double)startAngle; mouseAngle += 6.2831854820251465) {
            }
            while (mouseAngle >= (double)endAngle) {
                mouseAngle -= 6.2831854820251465;
            }
        }
        this.hovered = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            float startAngle = this.getAngleFor((float)i - 0.5f);
            float endAngle = this.getAngleFor((float)i + 0.5f);
            if (!(mouseAngle >= (double)startAngle) || !(mouseAngle < (double)endAngle) || !(mousePos >= 50.0) || !(mousePos < 100.0)) continue;
            this.hovered = i;
            break;
        }
    }

    private float getAngleFor(double i) {
        if (this.items.isEmpty()) {
            return 0.0f;
        }
        return (float)((i / (double)this.items.size() + 0.25) * 6.2831854820251465 + Math.PI);
    }
}

