/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.screen.tab;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.gui.screen.JujutsuScreen;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTab;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTabType;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.c2s.SetDomainSizeC2SPacket;

public class DomainCustomizationTab
extends JJKTab {
    private static final Component TITLE = Component.m_237115_((String)String.format("gui.%s.domain_customization", "jujutsu_kaisen"));
    private static final ResourceLocation BACKGROUND = new ResourceLocation("textures/gui/advancements/backgrounds/stone.png");
    private ForgeSlider sizeSlider;
    private float oldSize;

    public DomainCustomizationTab(Minecraft minecraft, JujutsuScreen screen, JJKTabType type, int index, int page) {
        super(minecraft, screen, type, index, page, Items.f_42686_.m_7968_(), TITLE, BACKGROUND, false);
    }

    @Override
    public void tick() {
        float size = (float)this.sizeSlider.getValue();
        if (size != this.oldSize) {
            if (this.minecraft != null && this.minecraft.f_91074_ != null) {
                ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                PacketHandler.sendToServer(new SetDomainSizeC2SPacket(size));
                cap.setDomainSize(size);
            }
            this.oldSize = size;
        }
    }

    @Override
    public void drawContents(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.drawContents(pGuiGraphics, pX, pY);
        int i = (this.screen.f_96543_ - 252) / 2;
        int j = (this.screen.f_96544_ - 140) / 2;
        Font font = this.minecraft.f_91062_;
        MutableComponent mutableComponent = Component.m_237115_((String)String.format("gui.%s.domain_customization.size", "jujutsu_kaisen"));
        Objects.requireNonNull(this.minecraft.f_91062_);
        pGuiGraphics.m_280614_(font, (Component)mutableComponent, i + 71, j + (124 - 9 - 8) / 2, 0xFFFFFF, true);
    }

    @Override
    public void addWidgets() {
        if (this.minecraft == null || this.minecraft.f_91074_ == null) {
            return;
        }
        ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        int i = (this.screen.f_96543_ - 252) / 2;
        int j = (this.screen.f_96544_ - 140) / 2;
        this.sizeSlider = new ForgeSlider(i + 71, j + 62, 110, 16, (Component)Component.m_237119_(), (Component)Component.m_237119_(), (double)((Double)ConfigHolder.SERVER.minimumDomainSize.get()).floatValue(), (double)((Double)ConfigHolder.SERVER.maximumDomainSize.get()).floatValue(), (double)cap.getDomainSize(), 0.1, 0, true);
        this.addRenderableWidget(this.sizeSlider);
    }
}

