/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.client.FakeEntityRenderer;
import radon.jujutsu_kaisen.client.particle.JJKParticles;

public class MirageParticle<T extends MirageParticleOptions>
extends TextureSheetParticle {
    private final int entityId;
    @Nullable
    private Entity entity;
    @Nullable
    private FakeEntityRenderer renderer;

    protected MirageParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, T options) {
        super(pLevel, pX, pY, pZ);
        this.f_107225_ = 10;
        this.f_107215_ = pXSpeed;
        this.f_107216_ = pYSpeed;
        this.f_107217_ = pZSpeed;
        this.entityId = ((MirageParticleOptions)options).entityId();
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107230_ = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        if (this.entity == null) {
            this.entity = this.f_107208_.m_6815_(this.entityId);
            if (this.entity == null) {
                return;
            }
            this.renderer = new FakeEntityRenderer(this.entity);
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public void m_5744_(@NotNull VertexConsumer pBuffer, @NotNull Camera pRenderInfo, float pPartialTicks) {
        if (this.renderer == null) {
            return;
        }
        this.renderer.setAlpha(this.f_107230_);
        this.renderer.render(this.getPos(), pPartialTicks);
    }

    public record MirageParticleOptions(int entityId) implements ParticleOptions
    {
        public static ParticleOptions.Deserializer<MirageParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<MirageParticleOptions>(){

            @NotNull
            public MirageParticleOptions fromCommand(@NotNull ParticleType<MirageParticleOptions> type, @NotNull StringReader reader) throws CommandSyntaxException {
                return new MirageParticleOptions(reader.readInt());
            }

            @NotNull
            public MirageParticleOptions fromNetwork(@NotNull ParticleType<MirageParticleOptions> type, @NotNull FriendlyByteBuf buf) {
                return new MirageParticleOptions(buf.readInt());
            }
        };

        @NotNull
        public ParticleType<?> m_6012_() {
            return (ParticleType)JJKParticles.MIRAGE.get();
        }

        public void m_7711_(FriendlyByteBuf buf) {
            buf.writeInt(this.entityId);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.entityId);
        }
    }

    public static class Provider
    implements ParticleProvider<MirageParticleOptions> {
        public Provider(SpriteSet ignored) {
        }

        public Particle createParticle(@NotNull MirageParticleOptions pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new MirageParticle<MirageParticleOptions>(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, pType);
        }
    }
}

