/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.client.FakeEntityRenderer;
import radon.jujutsu_kaisen.client.particle.JJKParticles;
import radon.jujutsu_kaisen.client.slice.CutModelUtil;
import radon.jujutsu_kaisen.client.slice.GJK;
import radon.jujutsu_kaisen.client.slice.RigidBody;

public class SlicedEntityParticle
extends TextureSheetParticle {
    private static final List<SlicedEntityParticle> ALL = new ArrayList<SlicedEntityParticle>();
    private final int entityId;
    private final Vector3f plane;
    private final float distance;
    @Nullable
    private LivingEntity entity;
    @Nullable
    private FakeEntityRenderer renderer;
    private final List<RigidBody> parts = new ArrayList<RigidBody>();

    protected SlicedEntityParticle(ClientLevel pLevel, double pX, double pY, double pZ, SliceParticleOptions options) {
        super(pLevel, pX, pY, pZ);
        this.entityId = options.entityId;
        this.plane = options.plane;
        this.distance = options.distance;
        this.f_107225_ = 1200;
        ALL.add(this);
    }

    public void m_5989_() {
        Entity entity;
        super.m_5989_();
        if (this.entity == null && (entity = this.f_107208_.m_6815_(this.entityId)) instanceof LivingEntity) {
            LivingEntity living;
            this.entity = living = (LivingEntity)entity;
            this.renderer = new FakeEntityRenderer((Entity)this.entity);
        }
        if (!this.m_107276_()) {
            ALL.remove((Object)this);
        }
        for (RigidBody part : this.parts) {
            part.tick();
        }
    }

    public static List<SlicedEntityParticle> getAll() {
        return ALL;
    }

    private static void generateChunks(List<List<RigidBody.CutModelData>> chunks, List<RigidBody.CutModelData> toSort) {
        GJK.margin = 0.01f;
        ArrayList chunk = new ArrayList();
        while (!toSort.isEmpty()) {
            boolean removed = false;
            ArrayList<RigidBody.CutModelData> toAdd = new ArrayList<RigidBody.CutModelData>();
            for (RigidBody.CutModelData a : chunk) {
                Iterator<RigidBody.CutModelData> iter = toSort.iterator();
                while (iter.hasNext()) {
                    RigidBody.CutModelData b = iter.next();
                    if (!b.collider.localBox.m_82400_((double)0.01f).m_82381_(a.collider.localBox) || !GJK.collidesAny(null, null, a.collider, b.collider)) continue;
                    removed = true;
                    toAdd.add(b);
                    iter.remove();
                }
            }
            chunk.addAll(toAdd);
            if (removed) continue;
            if (!chunk.isEmpty()) {
                chunks.add(chunk);
                chunk = new ArrayList();
            }
            chunk.add(toSort.remove(0));
        }
        if (!chunk.isEmpty()) {
            chunks.add(chunk);
        }
        GJK.margin = 0.0f;
    }

    public void m_5744_(@NotNull VertexConsumer pBuffer, @NotNull Camera pRenderInfo, float pPartialTicks) {
    }

    public void actuallyRender(PoseStack poseStack, float partialTicks) {
        if (this.entity == null || this.renderer == null) {
            return;
        }
        if (this.parts.isEmpty()) {
            this.renderer.setup(() -> {
                ArrayList<RigidBody.CutModelData> top = new ArrayList<RigidBody.CutModelData>();
                ArrayList<RigidBody.CutModelData> bottom = new ArrayList<RigidBody.CutModelData>();
                CutModelUtil.collect(this.renderer, this.plane, this.distance, partialTicks, top, bottom);
                ArrayList<List<RigidBody.CutModelData>> chunks = new ArrayList<List<RigidBody.CutModelData>>();
                SlicedEntityParticle.generateChunks(chunks, top);
                SlicedEntityParticle.generateChunks(chunks, bottom);
                double d0 = Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_);
                double d1 = Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_);
                double d2 = Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_);
                for (List list : chunks) {
                    RigidBody part = new RigidBody((Level)this.f_107208_, d0, d1, d2);
                    part.addChunk(list);
                    float direction = ((RigidBody.CutModelData)list.get((int)0)).flip ? -1.0f : 1.0f;
                    part.impulseVelocityDirect(new Vec3((double)(this.plane.x * direction), (double)(this.plane.y * direction), (double)(this.plane.z * direction)), part.globalCentroid);
                    this.parts.add(part);
                }
                for (RigidBody rigidBody : this.parts) {
                    rigidBody.addParts(this.parts);
                }
            });
        }
        if (this.parts.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher dispatcher = mc.m_91290_();
        int packedLight = dispatcher.m_114394_((Entity)this.entity, partialTicks);
        for (RigidBody part : this.parts) {
            part.render(poseStack, packedLight, partialTicks);
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public record SliceParticleOptions(int entityId, Vector3f plane, float distance) implements ParticleOptions
    {
        public static final ParticleOptions.Deserializer<SliceParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<SliceParticleOptions>(){

            @NotNull
            public SliceParticleOptions fromCommand(@NotNull ParticleType<SliceParticleOptions> type, @NotNull StringReader reader) throws CommandSyntaxException {
                int entityId = SliceParticleOptions.readEntityId(reader);
                reader.expect(' ');
                Vector3f plane = SliceParticleOptions.readVector3f(reader);
                reader.expect(' ');
                float distance = reader.readFloat();
                return new SliceParticleOptions(entityId, plane, distance);
            }

            @NotNull
            public SliceParticleOptions fromNetwork(@NotNull ParticleType<SliceParticleOptions> type, @NotNull FriendlyByteBuf buf) {
                int entityId = buf.readInt();
                Vector3f plane = SliceParticleOptions.readVector3fFromNetwork(buf);
                float distance = buf.readFloat();
                return new SliceParticleOptions(entityId, plane, distance);
            }
        };

        public static int readEntityId(StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            return reader.readInt();
        }

        public static Vector3f readVector3f(StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float x = reader.readFloat();
            reader.expect(' ');
            float y = reader.readFloat();
            reader.expect(' ');
            float z = reader.readFloat();
            return new Vector3f(x, y, z);
        }

        public static Vector3f readVector3fFromNetwork(FriendlyByteBuf buf) {
            return new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
        }

        public void m_7711_(@NotNull FriendlyByteBuf buf) {
            buf.writeInt(this.entityId);
            buf.writeFloat(this.plane.x);
            buf.writeFloat(this.plane.y);
            buf.writeFloat(this.plane.z);
            buf.writeFloat(this.distance);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d %.2f %.2f %.2f %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.entityId, Float.valueOf(this.plane.x), Float.valueOf(this.plane.y), Float.valueOf(this.plane.z), Float.valueOf(this.distance));
        }

        @NotNull
        public ParticleType<?> m_6012_() {
            return (ParticleType)JJKParticles.SLICE.get();
        }
    }

    public static class Provider
    implements ParticleProvider<SliceParticleOptions> {
        public Provider(SpriteSet ignored) {
        }

        public Particle createParticle(@NotNull SliceParticleOptions pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new SlicedEntityParticle(pLevel, pX, pY, pZ, pType);
        }
    }
}

