/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.slice;

import net.minecraft.world.phys.Vec3;
import radon.jujutsu_kaisen.client.slice.Contact;
import radon.jujutsu_kaisen.util.MathUtil;

public class ContactManifold {
    public static final float CONTACT_BREAK = 0.02f;
    public static final float CONTACT_BREAK_SQ = 4.0E-4f;
    public Contact[] contacts = new Contact[4];
    public int contactCount = 0;

    public void update() {
        Contact contact;
        int i;
        for (i = 0; i < this.contactCount; ++i) {
            contact = this.contacts[i];
            contact.globalA = contact.bodyA.localToGlobalPos(contact.localA);
            contact.globalB = contact.bodyB.localToGlobalPos(contact.localB);
            this.contacts[i].depth = (float)contact.globalA.m_82546_(contact.globalB).m_82526_(contact.normal);
        }
        for (i = 0; i < this.contactCount; ++i) {
            contact = this.contacts[i];
            if (contact.depth > 0.02f) {
                this.removeContact(i);
                --i;
                continue;
            }
            Vec3 proj = contact.globalA.m_82546_(contact.normal.m_82490_((double)contact.depth));
            double orthoDistToB = proj.m_82546_(contact.globalB).m_82556_();
            if (!(orthoDistToB > (double)4.0E-4f)) continue;
            this.removeContact(i);
            --i;
        }
    }

    public void removeContact(int idx) {
        this.contacts[idx] = null;
        for (int i = idx; i < 3; ++i) {
            this.contacts[i] = this.contacts[i + 1];
            this.contacts[i + 1] = null;
        }
        --this.contactCount;
    }

    public boolean addContact(Contact contact) {
        int idx = this.getContactIndex(contact);
        boolean replace = true;
        if (idx < 0) {
            if (this.contactCount < 4) {
                idx = this.contactCount;
                replace = false;
            } else {
                idx = this.getLeastRemoteIndex(contact);
            }
        }
        if (idx >= 0) {
            if (!replace) {
                ++this.contactCount;
            }
            this.contacts[idx] = contact;
            return true;
        }
        return false;
    }

    public int getLeastRemoteIndex(Contact c) {
        Vec3 b;
        Vec3 a;
        float deepest = -3.4028235E38f;
        int deepIdx = -1;
        for (int i = 0; i < this.contactCount; ++i) {
            if (!(this.contacts[i].depth > deepest)) continue;
            deepest = this.contacts[i].depth;
            deepIdx = i;
        }
        double res0 = 0.0;
        double res1 = 0.0;
        double res2 = 0.0;
        double res3 = 0.0;
        if (deepIdx != 0) {
            a = c.localA.m_82546_(this.contacts[1].localA);
            b = this.contacts[3].localA.m_82546_(this.contacts[2].localA);
            res0 = a.m_82537_(b).m_82556_();
        }
        if (deepIdx != 1) {
            a = c.localA.m_82546_(this.contacts[0].localA);
            b = this.contacts[3].localA.m_82546_(this.contacts[2].localA);
            res1 = a.m_82537_(b).m_82556_();
        }
        if (deepIdx != 2) {
            a = c.localA.m_82546_(this.contacts[0].localA);
            b = this.contacts[3].localA.m_82546_(this.contacts[1].localA);
            res2 = a.m_82537_(b).m_82556_();
        }
        if (deepIdx != 3) {
            a = c.localA.m_82546_(this.contacts[0].localA);
            b = this.contacts[2].localA.m_82546_(this.contacts[1].localA);
            res3 = a.m_82537_(b).m_82556_();
        }
        return MathUtil.absMaxIdx(res0, res1, res2, res3);
    }

    public int getContactIndex(Contact contact) {
        int idx = -1;
        double shortestDist = 4.0E-4f;
        for (int i = 0; i < this.contactCount; ++i) {
            double dist = this.contacts[i].localA.m_82546_(contact.localA).m_82556_();
            if (!(dist < shortestDist)) continue;
            shortestDist = dist;
            idx = i;
        }
        return idx;
    }
}

