/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.slice;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;
import radon.jujutsu_kaisen.client.slice.Collider;
import radon.jujutsu_kaisen.client.slice.LegacyMath;
import radon.jujutsu_kaisen.client.slice.RigidBody;

public class GJK {
    public static final int gjkMaxIterations = 64;
    public static final int epaMaxIterations = 128;
    public static float margin = 0.0f;
    public static Simplex csoSimplex = new Simplex();
    private static final List<Mkv[]> faces = new ArrayList<Mkv[]>();
    private static final List<Mkv[]> edges = new ArrayList<Mkv[]>();
    private static final Vec3[][] features = new Vec3[2][3];

    public static GJKInfo colliding(RigidBody bodyA, RigidBody bodyB, Collider a, Collider b) {
        return GJK.colliding(bodyA, bodyB, a, b, true);
    }

    public static boolean collidesAny(RigidBody bodyA, RigidBody bodyB, Collider a, Collider b) {
        return GJK.colliding(bodyA, bodyB, a, b, false) != null;
    }

    public static GJKInfo colliding(@Nullable RigidBody bodyA, @Nullable RigidBody bodyB, Collider a, Collider b, boolean epa) {
        GJKInfo result = new GJKInfo();
        csoSimplex.reset();
        Vec3 direction = new Vec3(0.0, 0.0, 1.0);
        Vec3 supportCSO = GJK.doCSOSupport((RigidBody)bodyA, (RigidBody)bodyB, (Collider)a, (Collider)b, (Vec3)direction).v;
        direction = supportCSO.m_82548_();
        block6: for (int iter = 0; iter < 64; ++iter) {
            supportCSO = GJK.doCSOSupport((RigidBody)bodyA, (RigidBody)bodyB, (Collider)a, (Collider)b, (Vec3)direction).v;
            if (supportCSO.m_82526_(direction) < 0.0) {
                result.result = Result.SEPARATED;
                if (!epa) {
                    return null;
                }
                return result;
            }
            switch (GJK.csoSimplex.size) {
                case 0: 
                case 1: {
                    continue block6;
                }
                case 2: {
                    Vec3 ab = GJK.csoSimplex.points[1].v.m_82546_(GJK.csoSimplex.points[0].v);
                    Vec3 ao = GJK.csoSimplex.points[0].v.m_82548_();
                    if (ab.m_82526_(ao) > 0.0) {
                        direction = ab.m_82537_(ao).m_82537_(ab);
                        continue block6;
                    }
                    GJK.csoSimplex.points[1] = null;
                    --GJK.csoSimplex.size;
                    direction = GJK.csoSimplex.points[0].v.m_82490_(-1.0);
                    continue block6;
                }
                case 3: {
                    Vec3 ab = GJK.csoSimplex.points[1].v.m_82546_(GJK.csoSimplex.points[0].v);
                    Vec3 ac = GJK.csoSimplex.points[2].v.m_82546_(GJK.csoSimplex.points[0].v);
                    Vec3 abc = ab.m_82537_(ac);
                    Vec3 ao = GJK.csoSimplex.points[0].v.m_82548_();
                    direction = GJK.triangleCase(ab, ac, abc, ao);
                    continue block6;
                }
                case 4: {
                    Vec3 ab = GJK.csoSimplex.points[1].v.m_82546_(GJK.csoSimplex.points[0].v);
                    Vec3 ac = GJK.csoSimplex.points[2].v.m_82546_(GJK.csoSimplex.points[0].v);
                    Vec3 ad = GJK.csoSimplex.points[3].v.m_82546_(GJK.csoSimplex.points[0].v);
                    Vec3 ao = GJK.csoSimplex.points[0].v.m_82548_();
                    Vec3 dir = GJK.tetraCase(ab, ac, ad, ao);
                    if (dir == null) {
                        if (epa) {
                            GJK.EPA(bodyA, bodyB, a, b, result);
                        }
                        return result;
                    }
                    direction = dir;
                }
            }
        }
        result.result = Result.GJK_FAILED;
        return result;
    }

    public static Vec3 triangleCase(Vec3 ab, Vec3 ac, Vec3 abc, Vec3 ao) {
        if (abc.m_82537_(ac).m_82526_(ao) > 0.0) {
            if (ac.m_82526_(ao) > 0.0) {
                GJK.csoSimplex.points[1] = GJK.csoSimplex.points[2];
                GJK.csoSimplex.points[2] = null;
                --GJK.csoSimplex.size;
                return ac.m_82537_(ao).m_82537_(ac);
            }
            if (ab.m_82526_(ao) > 0.0) {
                GJK.csoSimplex.points[2] = null;
                --GJK.csoSimplex.size;
                return ab.m_82537_(ao).m_82537_(ab);
            }
            GJK.csoSimplex.points[1] = null;
            GJK.csoSimplex.points[2] = null;
            GJK.csoSimplex.size -= 2;
            return ao;
        }
        if (ab.m_82537_(abc).m_82526_(ao) > 0.0) {
            if (ab.m_82526_(ao) > 0.0) {
                GJK.csoSimplex.points[2] = null;
                --GJK.csoSimplex.size;
                return ab.m_82537_(ao).m_82537_(ab);
            }
            GJK.csoSimplex.points[1] = null;
            GJK.csoSimplex.points[2] = null;
            GJK.csoSimplex.size -= 2;
            return ao;
        }
        if (abc.m_82526_(ao) > 0.0) {
            return abc;
        }
        Mkv tmp = GJK.csoSimplex.points[2];
        GJK.csoSimplex.points[2] = GJK.csoSimplex.points[1];
        GJK.csoSimplex.points[1] = tmp;
        return abc.m_82548_();
    }

    public static Vec3 tetraCase(Vec3 ab, Vec3 ac, Vec3 ad, Vec3 ao) {
        if (ab.m_82537_(ac).m_82526_(ao) > 0.0) {
            GJK.csoSimplex.points[3] = null;
            --GJK.csoSimplex.size;
            return GJK.triangleCase(ab, ac, ab.m_82537_(ac), ao);
        }
        if (ac.m_82537_(ad).m_82526_(ao) > 0.0) {
            GJK.csoSimplex.points[1] = GJK.csoSimplex.points[2];
            GJK.csoSimplex.points[2] = GJK.csoSimplex.points[3];
            GJK.csoSimplex.points[3] = null;
            --GJK.csoSimplex.size;
            return GJK.triangleCase(ac, ad, ac.m_82537_(ad), ao);
        }
        if (ad.m_82537_(ab).m_82526_(ao) > 0.0) {
            GJK.csoSimplex.points[2] = GJK.csoSimplex.points[1];
            GJK.csoSimplex.points[1] = GJK.csoSimplex.points[3];
            GJK.csoSimplex.points[3] = null;
            --GJK.csoSimplex.size;
            return GJK.triangleCase(ad, ab, ad.m_82537_(ab), ao);
        }
        return null;
    }

    public static Mkv doCSOSupport(RigidBody bodyA, RigidBody bodyB, Collider a, Collider b, Vec3 direction) {
        Vec3 supportCSO = GJK.csoSupport(bodyA, bodyB, a, b, direction);
        Mkv vert = new Mkv(supportCSO, direction);
        csoSimplex.push(vert);
        return vert;
    }

    public static Vec3 csoSupport(RigidBody bodyA, RigidBody bodyB, Collider a, Collider b, Vec3 dir) {
        return GJK.localSupport(bodyA, a, dir).m_82546_(GJK.localSupport(bodyB, b, dir.m_82548_()));
    }

    public static Vec3 localSupport(RigidBody body, Collider collider, Vec3 worldDir) {
        if (body != null) {
            Vec3 localDir = body.globalToLocalVec(worldDir);
            if (margin != 0.0f) {
                localDir = localDir.m_82541_();
                return body.localToGlobalPos(collider.support(localDir).m_82549_(localDir.m_82490_((double)margin)));
            }
            return body.localToGlobalPos(collider.support(localDir));
        }
        if (margin != 0.0f) {
            worldDir = worldDir.m_82541_();
            return collider.support(worldDir).m_82549_(worldDir.m_82490_((double)margin));
        }
        return collider.support(worldDir);
    }

    public static void EPA(RigidBody bodyA, RigidBody bodyB, Collider a, Collider b, GJKInfo info) {
        faces.add(GJK.buildFace(GJK.csoSimplex.points[0], GJK.csoSimplex.points[1], GJK.csoSimplex.points[2]));
        faces.add(GJK.buildFace(GJK.csoSimplex.points[0], GJK.csoSimplex.points[2], GJK.csoSimplex.points[3]));
        faces.add(GJK.buildFace(GJK.csoSimplex.points[0], GJK.csoSimplex.points[3], GJK.csoSimplex.points[1]));
        faces.add(GJK.buildFace(GJK.csoSimplex.points[1], GJK.csoSimplex.points[2], GJK.csoSimplex.points[3]));
        for (int i = 0; i < 128; ++i) {
            Mkv[] closestFace = null;
            double smallestDist = Double.MAX_VALUE;
            for (Mkv[] face : faces) {
                double lenSq = GJK.originDistToPlaneSq(face);
                if (!(lenSq < smallestDist)) continue;
                smallestDist = lenSq;
                closestFace = face;
            }
            Mkv support = GJK.doCSOSupport(bodyA, bodyB, a, b, closestFace[3].v);
            float epsilon = 1.0E-5f;
            if (GJK.distToPlaneSq(closestFace, support.v) < (double)1.0E-5f) {
                info.result = Result.COLLIDING;
                Vec3 separation = GJK.planeProjectOrigin(closestFace);
                info.normal = separation.m_82541_();
                info.depth = (float)separation.m_82553_();
                for (int j = 0; j < 3; ++j) {
                    GJK.features[0][j] = GJK.localSupport(bodyA, a, closestFace[j].r);
                    GJK.features[1][j] = GJK.localSupport(bodyB, b, closestFace[j].r.m_82548_());
                }
                Vec3 bCoords = GJK.barycentricCoords(closestFace, separation);
                info.contactPointA = new Vec3(GJK.features[0][0].f_82479_ * bCoords.f_82479_ + GJK.features[0][1].f_82479_ * bCoords.f_82480_ + GJK.features[0][2].f_82479_ * bCoords.f_82481_, GJK.features[0][0].f_82480_ * bCoords.f_82479_ + GJK.features[0][1].f_82480_ * bCoords.f_82480_ + GJK.features[0][2].f_82480_ * bCoords.f_82481_, GJK.features[0][0].f_82481_ * bCoords.f_82479_ + GJK.features[0][1].f_82481_ * bCoords.f_82480_ + GJK.features[0][2].f_82481_ * bCoords.f_82481_);
                info.contactPointB = new Vec3(GJK.features[1][0].f_82479_ * bCoords.f_82479_ + GJK.features[1][1].f_82479_ * bCoords.f_82480_ + GJK.features[1][2].f_82479_ * bCoords.f_82481_, GJK.features[1][0].f_82480_ * bCoords.f_82479_ + GJK.features[1][1].f_82480_ * bCoords.f_82480_ + GJK.features[1][2].f_82480_ * bCoords.f_82481_, GJK.features[1][0].f_82481_ * bCoords.f_82479_ + GJK.features[1][1].f_82481_ * bCoords.f_82480_ + GJK.features[1][2].f_82481_ * bCoords.f_82481_);
                faces.clear();
                return;
            }
            Iterator<Mkv[]> iter = faces.iterator();
            while (iter.hasNext()) {
                Mkv[] face = iter.next();
                if (!(face[3].v.m_82526_(support.v.m_82546_(face[0].v)) > 0.0)) continue;
                iter.remove();
                Mkv[] edge = new Mkv[]{face[1], face[0]};
                if (!GJK.removeEdge(edge)) {
                    edge[0] = face[0];
                    edge[1] = face[1];
                    edges.add(edge);
                }
                if (!GJK.removeEdge(edge = new Mkv[]{face[2], face[1]})) {
                    edge[0] = face[1];
                    edge[1] = face[2];
                    edges.add(edge);
                }
                if (GJK.removeEdge(edge = new Mkv[]{face[0], face[2]})) continue;
                edge[0] = face[2];
                edge[1] = face[0];
                edges.add(edge);
            }
            for (Mkv[] edge : edges) {
                faces.add(GJK.buildFace(edge[0], edge[1], support));
            }
            edges.clear();
        }
        faces.clear();
        info.result = Result.EPA_FAILED;
    }

    public static boolean removeEdge(Mkv[] edge) {
        Iterator<Mkv[]> iter = edges.iterator();
        while (iter.hasNext()) {
            Mkv[] edge2 = iter.next();
            if (edge[0] != edge2[0] || edge[1] != edge2[1]) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public static Vec3 planeProjectOrigin(Mkv[] face) {
        Vec3 point = face[0].v.m_82548_();
        double dot = face[3].v.m_82526_(point);
        return face[3].v.m_82490_((double)((float)dot)).m_82548_();
    }

    public static double distToPlaneSq(Mkv[] face, Vec3 point) {
        double dot = face[3].v.m_82526_(point.m_82546_(face[0].v));
        Vec3 proj = face[3].v.m_82490_((double)((float)dot));
        return proj.m_82556_();
    }

    public static double originDistToPlaneSq(Mkv[] face) {
        double dot = face[0].v.m_82526_(face[3].v);
        Vec3 proj = face[3].v.m_82490_((double)((float)dot));
        return proj.m_82556_();
    }

    public static Mkv[] buildFace(Mkv a, Mkv b, Mkv c) {
        Vec3 ab = b.v.m_82546_(a.v);
        Vec3 ac = c.v.m_82546_(a.v);
        Vec3 ao = a.v.m_82548_();
        Vec3 normal = LegacyMath.normalize(ab.m_82537_(ac));
        if (normal.m_82526_(ao) < 0.0) {
            return new Mkv[]{a, b, c, new Mkv(normal, null)};
        }
        return new Mkv[]{a, c, b, new Mkv(normal.m_82548_(), null)};
    }

    public static Vec3 barycentricCoords(Mkv[] face, Vec3 point) {
        double u = (float)face[1].v.m_82546_(point).m_82537_(face[2].v.m_82546_(point)).m_82553_();
        double v = (float)face[0].v.m_82546_(point).m_82537_(face[2].v.m_82546_(point)).m_82553_();
        double w = (float)face[0].v.m_82546_(point).m_82537_(face[1].v.m_82546_(point)).m_82553_();
        double uvw = u + v + w;
        return new Vec3(u, v, w).m_82490_(1.0 / uvw);
    }

    public static class GJKInfo {
        public Result result;
        public Vec3 normal;
        public float depth;
        public Vec3 contactPointA;
        public Vec3 contactPointB;
    }

    public static class Simplex {
        public int size = 0;
        public Mkv[] points = new Mkv[4];

        public void push(Mkv vec) {
            for (int i = Math.min(this.size, 2); i >= 0; --i) {
                this.points[i + 1] = this.points[i];
            }
            this.points[0] = vec;
            ++this.size;
            if (this.size > 4) {
                this.size = 4;
            }
        }

        public void reset() {
            this.size = 0;
            for (int i = 0; i < 4; ++i) {
                this.points[i] = null;
            }
        }

        public Simplex copy() {
            Simplex simp = new Simplex();
            simp.size = this.size;
            for (int i = 0; i < 4; ++i) {
                simp.points[i] = this.points[i].copy();
            }
            return simp;
        }
    }

    public static class Mkv {
        public Vec3 v;
        public Vec3 r;

        public Mkv(Vec3 point, Vec3 direction) {
            this.v = point;
            this.r = direction;
        }

        public Mkv copy() {
            return new Mkv(this.v, this.r);
        }
    }

    public static enum Result {
        COLLIDING,
        SEPARATED,
        GJK_FAILED,
        EPA_FAILED;

    }
}

