/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;

public class LivesCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode node = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"jjklives").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"lives", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            int lives = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"lives");
            return LivesCommand.setLives((CommandSourceStack)ctx.getSource(), target, lives);
        }))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            return LivesCommand.addLives((CommandSourceStack)ctx.getSource(), target, amount);
        }))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            return LivesCommand.getLives((CommandSourceStack)ctx.getSource(), target);
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"jjklives").requires(source -> source.m_6761_(2))).redirect((CommandNode)node));
    }

    private static int setLives(CommandSourceStack source, ServerPlayer player, int count) {
        ISorcererData cap = (ISorcererData)player.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        cap.setLives(count);
        PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
        return 1;
    }

    private static int addLives(CommandSourceStack source, ServerPlayer player, int amount) {
        ISorcererData cap = (ISorcererData)player.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        int current = cap.getLives();
        int newCount = current + amount;
        cap.setLives(newCount);
        PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
        return 1;
    }

    private static int getLives(CommandSourceStack source, ServerPlayer player) {
        ISorcererData cap = (ISorcererData)player.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        int lives = cap.getLives();
        source.m_288197_(() -> Component.m_237113_((String)(player.m_7755_().getString() + " has " + lives + " lives.")), false);
        return lives;
    }
}

