/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.damage;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import radon.jujutsu_kaisen.ability.base.Ability;

public class JJKDamageSources {
    public static final ResourceKey<DamageType> JUJUTSU = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("jujutsu_kaisen", "jujutsu"));
    public static final ResourceKey<DamageType> WORLD_SLASH = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("jujutsu_kaisen", "world_slash"));
    public static final ResourceKey<DamageType> SOUL = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("jujutsu_kaisen", "soul"));
    public static final ResourceKey<DamageType> SELF = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("jujutsu_kaisen", "self"));
    public static final ResourceKey<DamageType> SPLIT_SOUL_KATANA = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("jujutsu_kaisen", "split_soul_katana"));

    public static JujutsuDamageSource jujutsuAttack(LivingEntity source, @Nullable Ability ability) {
        RegistryAccess registry = source.m_9236_().m_9598_();
        Registry types = registry.m_175515_(Registries.f_268580_);
        return new JujutsuDamageSource((Holder.Reference<DamageType>)types.m_246971_(JUJUTSU), source, ability);
    }

    public static JujutsuDamageSource indirectJujutsuAttack(Entity source, @Nullable LivingEntity indirect, @Nullable Ability ability) {
        RegistryAccess registry = source.m_9236_().m_9598_();
        Registry types = registry.m_175515_(Registries.f_268580_);
        return new JujutsuDamageSource((Holder.Reference<DamageType>)types.m_246971_(JUJUTSU), source, indirect, ability);
    }

    public static DamageSource worldSlash(Entity source, @Nullable LivingEntity indirect) {
        RegistryAccess registry = source.m_9236_().m_9598_();
        Registry types = registry.m_175515_(Registries.f_268580_);
        return new DamageSource((Holder)types.m_246971_(WORLD_SLASH), source, (Entity)indirect);
    }

    public static DamageSource soulAttack(LivingEntity source) {
        RegistryAccess registry = source.m_9236_().m_9598_();
        Registry types = registry.m_175515_(Registries.f_268580_);
        return new DamageSource((Holder)types.m_246971_(SOUL), (Entity)source);
    }

    public static DamageSource self(LivingEntity source) {
        RegistryAccess registry = source.m_9236_().m_9598_();
        Registry types = registry.m_175515_(Registries.f_268580_);
        return new DamageSource((Holder)types.m_246971_(SELF), (Entity)source);
    }

    public static DamageSource splitSoulKatanaAttack(LivingEntity source) {
        RegistryAccess registry = source.m_9236_().m_9598_();
        Registry types = registry.m_175515_(Registries.f_268580_);
        return new DamageSource((Holder)types.m_246971_(SPLIT_SOUL_KATANA), (Entity)source);
    }

    public static class JujutsuDamageSource
    extends DamageSource {
        @Nullable
        private final Ability ability;

        public JujutsuDamageSource(Holder.Reference<DamageType> holderOrThrow, Entity source, @Nullable LivingEntity indirect, @Nullable Ability ability) {
            super(holderOrThrow, source, (Entity)indirect);
            this.ability = ability;
        }

        public JujutsuDamageSource(Holder.Reference<DamageType> holderOrThrow, @Nullable LivingEntity mob, @Nullable Ability ability) {
            super(holderOrThrow, (Entity)mob);
            this.ability = ability;
        }

        @Nullable
        public Ability getAbility() {
            return this.ability;
        }
    }
}

