/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.DomainExpansion;
import radon.jujutsu_kaisen.block.JJKBlocks;
import radon.jujutsu_kaisen.block.entity.DomainBlockEntity;
import radon.jujutsu_kaisen.block.entity.VeilBlockEntity;
import radon.jujutsu_kaisen.block.entity.VeilRodBlockEntity;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.RotationUtil;

public class ClosedDomainExpansionEntity
extends DomainExpansionEntity {
    private static final EntityDataAccessor<Integer> DATA_RADIUS = SynchedEntityData.m_135353_(ClosedDomainExpansionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int total;
    private final Map<UUID, Vec3> positions = new HashMap<UUID, Vec3>();
    private final List<BlockPos> blockPositions = new ArrayList<BlockPos>();

    public ClosedDomainExpansionEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public ClosedDomainExpansionEntity(LivingEntity owner, DomainExpansion ability, int radius) {
        this((EntityType)JJKEntities.CLOSED_DOMAIN_EXPANSION.get(), owner, ability, radius);
    }

    public ClosedDomainExpansionEntity(EntityType<?> pType, LivingEntity owner, DomainExpansion ability, int radius) {
        super(pType, owner, ability);
        Vec3 rawDir = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 horizontal = new Vec3(rawDir.f_82479_, 0.0, rawDir.f_82481_).m_82541_();
        Vec3 base = owner.m_20182_().m_82549_(horizontal.m_82490_((double)(radius - 5)));
        Vec3 finalPos = base.m_82492_(0.0, (double)radius, 0.0);
        this.m_7678_(finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_, RotationUtil.getTargetAdjustedYRot((Entity)owner), RotationUtil.getTargetAdjustedXRot((Entity)owner));
        this.f_19804_.m_135381_(DATA_RADIUS, (Object)radius);
    }

    @Override
    public boolean shouldCollapse(float strength) {
        int radius = this.getRadius();
        boolean completed = this.getTime() >= radius * 2;
        return completed && super.shouldCollapse(strength);
    }

    @Override
    public AABB getBounds() {
        return this.m_20191_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_RADIUS, (Object)0);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_RADIUS, (Object)pCompound.m_128451_("radius"));
        this.total = pCompound.m_128451_("total");
        for (Tag key : pCompound.m_128437_("positions", 10)) {
            CompoundTag nbt = (CompoundTag)key;
            this.positions.put(nbt.m_128342_("identifier"), new Vec3(nbt.m_128459_("pos_x"), nbt.m_128459_("pos_y"), nbt.m_128459_("pos_z")));
        }
        this.blockPositions.clear();
        ListTag blockList = pCompound.m_128437_("block_positions", 10);
        for (Tag tag : blockList) {
            CompoundTag nbt = (CompoundTag)tag;
            BlockPos pos = new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
            this.blockPositions.add(pos);
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("radius", this.getRadius());
        pCompound.m_128405_("total", this.total);
        ListTag positionsTag = new ListTag();
        for (Map.Entry<UUID, Vec3> entry : this.positions.entrySet()) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128362_("identifier", entry.getKey());
            Vec3 position = entry.getValue();
            nbt.m_128347_("pos_x", position.f_82479_);
            nbt.m_128347_("pos_y", position.f_82480_);
            nbt.m_128347_("pos_z", position.f_82481_);
            positionsTag.add((Object)nbt);
        }
        pCompound.m_128365_("positions", (Tag)positionsTag);
        ListTag blockList = new ListTag();
        for (BlockPos pos : this.blockPositions) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", pos.m_123341_());
            tag.m_128405_("y", pos.m_123342_());
            tag.m_128405_("z", pos.m_123343_());
            blockList.add((Object)tag);
        }
        pCompound.m_128365_("block_positions", (Tag)blockList);
    }

    public int getRadius() {
        return (Integer)this.f_19804_.m_135370_(DATA_RADIUS);
    }

    @Override
    public boolean isInsideBarrier(BlockPos pos) {
        int radius = this.getRadius();
        BlockPos center = BlockPos.m_274446_((Position)this.m_20182_().m_82520_(0.0, (double)radius, 0.0));
        BlockPos relative = pos.m_121996_((Vec3i)center);
        return relative.m_123331_(Vec3i.f_123288_) < (double)(radius * radius);
    }

    public boolean isWithinBarrier(BlockPos pos) {
        int radius = this.getRadius();
        BlockPos center = BlockPos.m_274446_((Position)this.m_20182_().m_82520_(0.0, (double)radius, 0.0));
        BlockPos relative = pos.m_121996_((Vec3i)center);
        return relative.m_123331_(Vec3i.f_123288_) < (double)((radius - 1) * (radius - 1));
    }

    private void createBlock(int delay, BlockPos pos, int radius, double distance, BlockEntity existing) {
        BlockEntity blockEntity;
        DomainBlockEntity be;
        UUID identifier;
        BlockState state = null;
        if (!this.m_9236_().m_46859_(pos)) {
            state = this.m_9236_().m_8055_(pos);
        }
        if (state != null && state.m_60713_(Blocks.f_50752_)) {
            return;
        }
        if (this.m_213877_()) {
            return;
        }
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        CompoundTag saved = null;
        if (existing instanceof VeilBlockEntity) {
            VeilBlockEntity be2 = (VeilBlockEntity)existing;
            return;
        }
        if (existing instanceof VeilRodBlockEntity) {
            VeilRodBlockEntity vrbe = (VeilRodBlockEntity)existing;
            return;
        }
        if (existing instanceof DomainBlockEntity) {
            BlockState original;
            DomainBlockEntity be3 = (DomainBlockEntity)existing;
            state = original = be3.getOriginal();
            saved = be3.getSaved();
        } else if (existing != null) {
            saved = existing.m_187480_();
        }
        DomainExpansion.IClosedDomain domain = (DomainExpansion.IClosedDomain)((Object)this.ability);
        List<Block> blocks = domain.getBlocks();
        List<Block> fill = domain.getFillBlocks();
        List<Block> floor = domain.getFloorBlocks();
        List<Block> decoration = domain.getDecorationBlocks();
        Block block = (Block)JJKBlocks.DOMAIN_AIR.get();
        BlockPos center = BlockPos.m_274446_((Position)this.m_20182_().m_82520_(0.0, (double)radius, 0.0));
        if (distance >= (double)(radius - 1)) {
            block = (Block)JJKBlocks.DOMAIN.get();
        } else if (distance >= (double)(radius - 2)) {
            block = blocks.get(this.f_19796_.m_188503_(blocks.size()));
        } else if (pos.m_123342_() < center.m_123342_()) {
            block = floor.isEmpty() ? fill.get(this.f_19796_.m_188503_(fill.size())) : floor.get(this.f_19796_.m_188503_(floor.size()));
        } else if (!decoration.isEmpty() && pos.m_123342_() == center.m_123342_()) {
            block = decoration.get(this.f_19796_.m_188503_(decoration.size()));
        }
        if (existing instanceof DomainBlockEntity && (identifier = (be = (DomainBlockEntity)existing).getIdentifier()) != null && ((ServerLevel)this.m_9236_()).m_8791_(identifier) instanceof DomainExpansionEntity && block == JJKBlocks.DOMAIN_AIR.get()) {
            return;
        }
        this.blockPositions.add(pos.m_7949_());
        be = ((ServerLevel)this.m_9236_()).m_7702_(pos);
        if (be != null && be instanceof Container) {
            Container container = (Container)be;
            container.m_6211_();
            ((ServerLevel)this.m_9236_()).m_46747_(pos);
        }
        boolean success = owner.m_9236_().m_7731_(pos, block.m_49966_(), 50);
        if (distance >= (double)(radius - 1) && success) {
            ++this.total;
        }
        if ((blockEntity = this.m_9236_().m_7702_(pos)) instanceof DomainBlockEntity) {
            DomainBlockEntity dmnbe = (DomainBlockEntity)blockEntity;
            dmnbe.create(this.f_19820_, delay, state, saved);
        }
    }

    private void applyPreStun() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        int radius = this.getRadius();
        BlockPos center = BlockPos.m_274446_((Position)this.m_20182_().m_82520_(0.0, (double)radius, 0.0));
        List entities = this.m_9236_().m_6443_(LivingEntity.class, new AABB((double)(center.m_123341_() - radius), (double)(center.m_123342_() - radius), (double)(center.m_123343_() - radius), (double)(center.m_123341_() + radius), (double)(center.m_123342_() + radius), (double)(center.m_123343_() + radius)), entity -> this.isInsideBarrier(entity.m_20183_()));
        for (LivingEntity entity2 : entities) {
            entity2.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.DOMAINSTUN.get(), 30, 1, false, false, false));
            entity2.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 6, false, false, false));
        }
    }

    private void createBarrier(boolean instant) {
        this.total = 0;
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        int radius = this.getRadius();
        BlockPos center = BlockPos.m_274446_((Position)this.m_20182_().m_82520_(0.0, (double)radius, 0.0));
        Vec3 direction = this.m_20154_();
        Vec3 behind = this.m_20182_().m_82546_(direction.m_82490_((double)(radius - 5))).m_82520_(0.0, (double)radius, 0.0);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    if (distance > (double)radius) continue;
                    BlockPos pos = center.m_7918_(x, y, z);
                    if (!this.m_9236_().m_46739_(pos)) continue;
                    int delay = (int)Math.round(pos.m_252807_().m_82554_(behind)) / 2 + 1;
                    ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                    if (instant) {
                        BlockEntity existing = this.m_9236_().m_7702_(pos);
                        if (existing instanceof VeilBlockEntity) {
                            VeilBlockEntity be = (VeilBlockEntity)existing;
                            if (!this.checkVeil(pos, owner)) {
                                this.m_146870_();
                                return;
                            }
                        }
                        this.createBlock(radius - delay, pos, radius, distance, existing);
                        continue;
                    }
                    cap.delayTickEvent(() -> {
                        BlockEntity existing = this.m_9236_().m_7702_(pos);
                        if (existing instanceof VeilBlockEntity) {
                            VeilBlockEntity be = (VeilBlockEntity)existing;
                            if (!this.checkVeil(pos, owner)) {
                                this.m_146870_();
                                return;
                            }
                        }
                        this.createBlock(radius - delay, pos, radius, distance, existing);
                    }, delay);
                }
            }
        }
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        int radius = this.getRadius() * 2;
        return EntityDimensions.m_20398_((float)radius, (float)radius);
    }

    private void doSureHitEffect(@NotNull LivingEntity owner) {
        for (LivingEntity entity : this.getAffected()) {
            if (JJKAbilities.hasTrait(entity, Trait.HEAVENLY_RESTRICTION)) {
                this.ability.onHitBlock(this, owner, entity.m_20183_());
                continue;
            }
            this.ability.onHitEntity(this, owner, entity, false);
        }
    }

    @Override
    public boolean checkSureHitEffect() {
        boolean completed;
        int radius = this.getRadius();
        boolean bl = completed = this.getTime() >= radius * 2;
        if (!completed) {
            return false;
        }
        Set<DomainExpansionEntity> domains = VeilHandler.getDomains((ServerLevel)this.m_9236_(), this.getBounds());
        for (DomainExpansionEntity domain : domains) {
            if (domain == this) continue;
            if (this.shouldCollapse(domain.getStrength())) {
                this.m_146870_();
            }
            return false;
        }
        return true;
    }

    public void onRemovedFromWorld() {
        LivingEntity owner;
        int burnout = Math.max(300, this.getTime());
        if (burnout > 900) {
            burnout = 900;
        }
        int realburnout = burnout;
        super.onRemovedFromWorld();
        if (!this.m_9236_().f_46443_ && (owner = this.getOwner()) != null) {
            owner.getCapability(SorcererDataHandler.INSTANCE).ifPresent(cap -> {
                cap.setBurnout(realburnout);
                cap.resetSpeedStacks();
                if (owner instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)owner;
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
                }
            });
        }
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_6210_();
    }

    private void check() {
        int radius = this.getRadius();
        Vec3 behind = this.m_20182_().m_82520_(0.0, (double)radius, 0.0);
        BlockPos center = BlockPos.m_274446_((Position)behind);
        int count = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    DomainBlockEntity be;
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    if (!(distance < (double)radius) || !(distance >= (double)(radius - 1))) continue;
                    BlockPos pos = center.m_7918_(x, y, z);
                    BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
                    if (!(blockEntity instanceof DomainBlockEntity) || (be = (DomainBlockEntity)blockEntity).getIdentifier() == null || !be.getIdentifier().equals(this.m_20148_())) continue;
                    ++count;
                }
            }
        }
        if ((float)count / (float)this.total < 0.75f) {
            this.m_146870_();
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
        Set<DomainExpansionEntity> domains = VeilHandler.getDomains((ServerLevel)this.m_9236_(), this.getBounds());
        for (DomainExpansionEntity domainExpansionEntity : domains) {
            if (domainExpansionEntity == this || !(domainExpansionEntity instanceof ClosedDomainExpansionEntity)) continue;
            ClosedDomainExpansionEntity closed = (ClosedDomainExpansionEntity)domainExpansionEntity;
            closed.createBarrier(true);
        }
        for (Map.Entry entry : this.positions.entrySet()) {
            UUID identifier = (UUID)entry.getKey();
            boolean stillWithin = false;
            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(identifier);
            if (entity == null || !this.isInsideBarrier(entity.m_20183_())) continue;
            Vec3 pos = (Vec3)entry.getValue();
            for (DomainExpansionEntity domain : domains) {
                ClosedDomainExpansionEntity closed;
                if (domain == this || !(domain instanceof ClosedDomainExpansionEntity) || !(closed = (ClosedDomainExpansionEntity)domain).isInsideBarrier(entity.m_20183_())) continue;
                stillWithin = true;
                break;
            }
            if (stillWithin) continue;
            entity.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        int n = this.getRadius();
        for (BlockPos pos : this.blockPositions) {
            BlockEntity be = serverLevel.m_7702_(pos);
            if (be instanceof DomainBlockEntity) {
                DomainBlockEntity domainBe = (DomainBlockEntity)be;
                UUID id = domainBe.getIdentifier();
                if (id == null || !id.equals(this.m_20148_())) continue;
                domainBe.destroy();
                continue;
            }
            serverLevel.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        this.blockPositions.clear();
        this.positions.clear();
    }

    @Override
    public void m_8119_() {
        ParticleOptions particle;
        boolean completed;
        super.m_8119_();
        this.m_6210_();
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        int radius = this.getRadius();
        boolean bl = completed = this.getTime() >= radius * 2;
        if (this.getTime() <= radius * 2) {
            BlockPos center = BlockPos.m_274446_((Position)this.m_20182_().m_82520_(0.0, (double)radius, 0.0));
            for (LivingEntity entity2 : this.m_9236_().m_6443_(LivingEntity.class, this.getBounds(), entity -> this.isInsideBarrier(entity.m_20183_()))) {
                if (!this.positions.containsKey(entity2.m_20148_())) {
                    this.positions.put(entity2.m_20148_(), entity2.m_20182_());
                }
                if (!(entity2.m_20186_() < (double)center.m_123342_())) continue;
                entity2.m_6021_(entity2.m_20185_(), (double)center.m_123342_(), entity2.m_20189_());
            }
        }
        if (this.checkSureHitEffect()) {
            this.doSureHitEffect(owner);
        }
        if (completed && this.getTime() % 20 == 0) {
            this.check();
            System.out.println(this.getTime());
        }
        if ((particle = ((DomainExpansion.IClosedDomain)((Object)this.ability)).getEnvironmentParticle()) != null) {
            AABB bounds = this.getBounds();
            for (BlockPos pos : BlockPos.m_235641_((RandomSource)this.f_19796_, (int)16, (int)((int)bounds.f_82288_), (int)((int)bounds.f_82289_), (int)((int)bounds.f_82290_), (int)((int)bounds.f_82291_), (int)((int)bounds.f_82292_), (int)((int)bounds.f_82293_))) {
                if (!this.isWithinBarrier(pos)) continue;
                Vec3 center = pos.m_252807_();
                ((ServerLevel)this.m_9236_()).m_8767_(particle, center.f_82479_, center.f_82480_, center.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (this.getTime() - 1 == 0) {
            this.applyPreStun();
            this.createBarrier(false);
        } else if (completed && !this.isInsideBarrier(owner.m_20183_())) {
            this.m_146870_();
        }
    }
}

