/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.client.particle.CursedEnergyParticle;
import radon.jujutsu_kaisen.client.particle.LightningParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.entity.JJKEntities;

public class NyoiStaffEntity
extends Entity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(NyoiStaffEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> DATA_CHARGED = SynchedEntityData.m_135353_(NyoiStaffEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;

    public NyoiStaffEntity(EntityType<? extends Entity> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public NyoiStaffEntity(LivingEntity owner, ItemStack stack, Vec3 pos) {
        super((EntityType)JJKEntities.NYOI_STAFF.get(), owner.m_9236_());
        this.setOwner(owner);
        this.setItem(stack);
        this.m_146884_(pos);
    }

    public boolean isCharged() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGED);
    }

    public void setCharged(boolean charged) {
        this.f_19804_.m_135381_(DATA_CHARGED, (Object)charged);
    }

    private void setItem(ItemStack stack) {
        this.f_19804_.m_135381_(DATA_ITEM_STACK, (Object)stack.m_255036_(1));
    }

    public ItemStack getItem() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ITEM_STACK);
    }

    public boolean m_6087_() {
        return true;
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (pPlayer == this.getOwner() && pPlayer.m_36356_(this.getItem())) {
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6096_(pPlayer, pHand);
    }

    public void m_8119_() {
        double z;
        double y;
        double x;
        int i;
        super.m_8119_();
        if (!this.isCharged()) {
            return;
        }
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        for (i = 0; i < 8; ++i) {
            x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)(this.m_20205_() * 1.25f);
            y = this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_();
            z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)(this.m_20205_() * 1.25f);
            double speed = (double)(this.m_20206_() * 0.1f) * this.f_19796_.m_188500_();
            this.m_9236_().m_7106_((ParticleOptions)new CursedEnergyParticle.CursedEnergyParticleOptions(ParticleColors.getCursedEnergyColor((Entity)owner), this.m_20205_() * 0.5f, 0.2f, 16), x, y, z, 0.0, speed, 0.0);
        }
        for (i = 0; i < 4; ++i) {
            x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)(this.m_20205_() * 2.0f);
            y = this.m_20186_() + this.f_19796_.m_188500_() * (double)(this.m_20206_() * 1.25f);
            z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)(this.m_20205_() * 2.0f);
            this.m_9236_().m_7106_((ParticleOptions)new LightningParticle.LightningParticleOptions(ParticleColors.getCursedEnergyColorBright(owner), 0.2f, 1), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_CHARGED, (Object)false);
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        if (this.ownerUUID != null) {
            pCompound.m_128362_("owner", this.ownerUUID);
        }
        pCompound.m_128365_("item", (Tag)this.getItem().m_41739_(new CompoundTag()));
        pCompound.m_128379_("charged", this.isCharged());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        if (pCompound.m_128403_("owner")) {
            this.ownerUUID = pCompound.m_128342_("owner");
        }
        this.setItem(ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("item")));
        this.setCharged(pCompound.m_128471_("charged"));
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        LivingEntity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? 0 : entity.m_19879_());
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        LivingEntity owner = (LivingEntity)this.m_9236_().m_6815_(pPacket.m_131509_());
        if (owner != null) {
            this.setOwner(owner);
        }
    }
}

