/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.curse;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.ai.goal.BetterFollowOwnerGoal;
import radon.jujutsu_kaisen.entity.ai.goal.SorcererGoal;
import radon.jujutsu_kaisen.entity.ai.goal.WaterWalkingFloatGoal;
import radon.jujutsu_kaisen.entity.base.ICommandable;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.entity.base.SummonEntity;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class RikaEntity
extends SummonEntity
implements ICommandable,
ISorcerer {
    private static final int DURATION = 6000;
    public static EntityDataAccessor<Integer> DATA_OPEN = SynchedEntityData.m_135353_(RikaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    private static final RawAnimation OPEN = RawAnimation.begin().thenPlayAndHold("misc.open");
    private static final RawAnimation SWING = RawAnimation.begin().thenPlay("attack.swing");

    public RikaEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public RikaEntity(LivingEntity owner) {
        this((EntityType<? extends TamableAnimal>)((EntityType)JJKEntities.RIKA.get()), owner.m_9236_());
        this.m_7105_(true);
        this.setOwner(owner);
        Vec3 pos = owner.m_20182_().m_82546_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_()));
        this.m_6027_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 1, true);
    }

    protected float m_274460_() {
        float speed = super.m_274460_();
        speed = this.m_5448_() != null ? (speed *= 25.0f) : (speed *= 5.0f);
        return speed;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22268_(Attributes.f_22280_, 0.33).m_22268_(Attributes.f_22276_, 72.0).m_22268_(Attributes.f_22284_, 30.0).m_22268_(Attributes.f_22278_, 0.25).m_22268_(Attributes.f_22281_, 21.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, pLevel);
        navigation.m_26440_(false);
        navigation.m_7008_(true);
        navigation.m_26443_(true);
        return navigation;
    }

    protected void m_8099_() {
        int goal = 1;
        int target = 1;
        this.f_21345_.m_25352_(goal++, (Goal)new WaterWalkingFloatGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(goal++, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.9, true));
        this.f_21345_.m_25352_(goal++, (Goal)new SorcererGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(goal++, (Goal)new BetterFollowOwnerGoal(this, 1.0, 10.0f, 5.0f, true));
        this.f_21345_.m_25352_(goal, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(target, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(target++, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(target, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OPEN, (Object)0);
    }

    public void setOpen(int duration) {
        this.f_19804_.m_135381_(DATA_OPEN, (Object)duration);
    }

    public int getOpen() {
        return (Integer)this.f_19804_.m_135370_(DATA_OPEN);
    }

    public boolean isOpen() {
        return this.getOpen() > 0;
    }

    private PlayState openPredicate(AnimationState<RikaEntity> animationState) {
        if (this.isOpen()) {
            return animationState.setAndContinue(OPEN);
        }
        return PlayState.STOP;
    }

    private PlayState swingPredicate(AnimationState<RikaEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(SWING);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Idle", state -> state.setAndContinue(IDLE))});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Open", this::openPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swing", this::swingPredicate)});
    }

    @Override
    public Summon<?> getAbility() {
        return (Summon)JJKAbilities.RIKA.get();
    }

    @Override
    public void m_8119_() {
        LivingEntity owner = this.m_269323_();
        if (!(this.m_9236_().f_46443_ || owner != null && !owner.m_213877_() && owner.m_6084_() && (this.m_21224_() || JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.RIKA.get())))) {
            this.m_146870_();
        } else {
            super.m_8119_();
            LivingEntity target = this.m_5448_();
            this.m_21839_(target != null && !target.m_213877_() && target.m_6084_());
            if (target != null) {
                this.f_21342_.m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), (double)0.85f);
            }
            if (owner != null && this.isOpen()) {
                Vec3 pos = owner.m_20182_().m_82546_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_())).m_82549_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82524_(90.0f).m_82490_(-0.45));
                this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, RotationUtil.getTargetAdjustedYRot((Entity)owner), RotationUtil.getTargetAdjustedXRot((Entity)owner));
                this.f_20886_ = this.f_20885_ = this.m_146908_();
            }
            if (!this.m_9236_().f_46443_) {
                if (this.m_21223_() != this.m_21233_()) {
                    this.m_5634_(0.075f);
                }
                int remaining = this.getOpen();
                ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (remaining > 0) {
                    if (--remaining == 0) {
                        this.m_146870_();
                    }
                    this.setOpen(remaining);
                }
                if (this.getTime() >= 6000) {
                    this.m_146870_();
                }
            }
        }
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return true;
    }

    @Override
    public boolean canJump() {
        return false;
    }

    @Override
    public boolean canChant() {
        return true;
    }

    @Override
    public float getExperience() {
        LivingEntity owner = this.m_269323_();
        if (owner == null || !owner.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return 0.0f;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getExperience();
    }

    @Override
    public float getMaxEnergy() {
        return 999999.0f;
    }

    @Override
    @Nullable
    public CursedTechnique getTechnique() {
        return null;
    }

    @Override
    public JujutsuType getJujutsuType() {
        return JujutsuType.SHIKIGAMI;
    }

    @Override
    public boolean canChangeTarget() {
        return true;
    }

    @Override
    public void changeTarget(LivingEntity target) {
        this.m_6710_(target);
    }
}

