/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.util.HelperMethods;

public class AirFrameEntity
extends Entity {
    private static final int DURATION = 8;
    private static final float DAMAGE = 18.0f;
    private static final double RANGE = 9.0;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;
    private float power;

    public AirFrameEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
    }

    public AirFrameEntity(LivingEntity owner, float power) {
        this((EntityType)JJKEntities.AIR_FRAME.get(), owner.m_9236_());
        this.setOwner(owner);
        this.power = power;
    }

    protected void m_8097_() {
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        if (this.ownerUUID != null) {
            pCompound.m_128362_("owner", this.ownerUUID);
        }
        pCompound.m_128350_("power", this.power);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        if (pCompound.m_128403_("owner")) {
            this.ownerUUID = pCompound.m_128342_("owner");
        }
        this.power = pCompound.m_128457_("power");
    }

    public float getPower() {
        return this.power;
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return pDistance < (d0 *= 64.0 * AirFrameEntity.m_20150_()) * d0;
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity owner = this.getOwner();
        if (!this.m_9236_().f_46443_ && (owner == null || owner.m_213877_() || owner.m_21224_())) {
            this.m_146870_();
        } else {
            super.m_8119_();
            if (this.m_9236_().f_46443_) {
                return;
            }
            if (this.f_19797_ >= 8) {
                if (owner != null) {
                    Vec3 center = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
                    ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, center.f_82479_, center.f_82480_, center.f_82481_, 0, 1.0, 0.0, 0.0, 1.0);
                    ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123812_, center.f_82479_, center.f_82480_, center.f_82481_, 0, 1.0, 0.0, 0.0, 1.0);
                    owner.m_9236_().m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (HelperMethods.RANDOM.m_188501_() - HelperMethods.RANDOM.m_188501_()) * 0.2f) * 0.7f);
                    for (Entity entity : owner.m_9236_().m_45933_(null, AABB.m_165882_((Vec3)center, (double)9.0, (double)9.0, (double)9.0))) {
                        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                        if (entity == owner && !cap.hasSelfHit()) continue;
                        entity.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack(this, owner, (Ability)JJKAbilities.AIR_FRAME.get()), 18.0f * this.getPower());
                    }
                }
                this.m_146870_();
            }
        }
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }
}

