/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.block.FakeWaterDurationBlock;
import radon.jujutsu_kaisen.block.JJKBlocks;
import radon.jujutsu_kaisen.block.entity.DurationBlockEntity;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WaterballEntity
extends JujutsuProjectile
implements GeoEntity {
    private static final RawAnimation SPIN = RawAnimation.begin().thenLoop("misc.spin");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int DURATION = 15;
    private static final int INTERVAL = 5;
    private static final int WIDTH = 30;
    private static final int HEIGHT = 10;
    private static final float DAMAGE = 13.0f;

    public WaterballEntity(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public WaterballEntity(LivingEntity owner, float power) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.WATERBALL.get()), owner.m_9236_(), (Entity)owner, power);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        EntityUtil.offset((Entity)this, look, new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look));
    }

    private static boolean isInside(LivingEntity owner, BlockPos pos) {
        BlockPos center = owner.m_20183_();
        BlockPos relative = pos.m_121996_((Vec3i)center);
        return relative.m_123342_() <= 10 && relative.m_123331_(Vec3i.f_123288_) < 900.0;
    }

    private void createWave(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        BlockPos center = owner.m_20183_();
        owner.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12278_, SoundSource.MASTER, 0.5f, 0.7f + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 0.8f);
        owner.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11824_, SoundSource.MASTER, 1.0f, 1.0f + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 0.3f);
        for (Entity entity : owner.m_9236_().m_45933_((Entity)owner, AABB.m_165882_((Vec3)owner.m_20182_(), (double)30.0, (double)10.0, (double)30.0))) {
            if (!WaterballEntity.isInside(owner, entity.m_20183_()) || !entity.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.DISASTER_TIDES.get()), 13.0f * this.getPower())) continue;
            entity.m_20256_(entity.m_20182_().m_82546_(center.m_252807_()));
            entity.f_19802_ = 0;
        }
        for (int i = 0; i < 30; ++i) {
            int horizontal = i;
            int duration = (i + 1) / 3;
            cap.delayTickEvent(() -> {
                for (int j = -10; j < 10; ++j) {
                    for (int x = -horizontal; x <= horizontal; ++x) {
                        for (int z = -horizontal; z <= horizontal; ++z) {
                            BlockState state;
                            BlockPos pos;
                            double distance = Math.sqrt(x * x + -j * -j + z * z);
                            if (!(distance <= (double)horizontal) || !(distance >= (double)(horizontal - 1)) || (pos = center.m_7918_(x, j, z)) == center || !(state = owner.m_9236_().m_8055_(pos)).m_60795_() || state.m_60815_()) continue;
                            owner.m_9236_().m_46597_(pos, ((FakeWaterDurationBlock)((Object)((Object)JJKBlocks.FAKE_WATER_DURATION.get()))).m_49966_());
                            BlockEntity patt5051$temp = owner.m_9236_().m_7702_(pos);
                            if (!(patt5051$temp instanceof DurationBlockEntity)) continue;
                            DurationBlockEntity be = (DurationBlockEntity)patt5051$temp;
                            be.create(duration, state);
                        }
                    }
                }
            }, i);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        if (this.getTime() == 1) {
            owner.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11767_, SoundSource.MASTER, 8.0f, 3.0f);
            owner.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12041_, SoundSource.MASTER, 1.0f, 1.0f);
        }
        if (this.getTime() <= 15) {
            if (!owner.m_6084_()) {
                this.m_146870_();
            } else {
                if (this.getTime() % 5 == 0) {
                    owner.m_6674_(InteractionHand.MAIN_HAND);
                }
                if (!this.m_9236_().f_46443_ && this.getTime() % 5 == 0) {
                    this.createWave(owner);
                }
                Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
                Vec3 spawn = new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look);
                this.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
                double d0 = look.m_165924_();
                this.m_146922_((float)(Mth.m_14136_((double)look.f_82479_, (double)look.f_82481_) * 57.2957763671875));
                this.m_146926_((float)(Mth.m_14136_((double)look.f_82480_, (double)d0) * 57.2957763671875));
                this.f_19859_ = this.m_146908_();
                this.f_19860_ = this.m_146909_();
            }
        } else {
            this.m_146870_();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Spin", animationState -> animationState.setAndContinue(SPIN))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

