/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.effect.WoodShieldSegmentEntity;

public class WoodShieldEntity
extends Mob {
    private static final float STRENGTH = 85.0f;
    @Nullable
    private Vec3 pos;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;

    public WoodShieldEntity(EntityType<? extends Mob> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public WoodShieldEntity(LivingEntity owner) {
        super((EntityType)JJKEntities.WOOD_SHIELD.get(), owner.m_9236_());
        this.setOwner(owner);
        this.pos = owner.m_20182_();
        this.m_146884_(owner.m_20182_());
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        AttributeInstance attribute = this.m_21051_(Attributes.f_22276_);
        if (attribute != null) {
            attribute.m_22100_((double)(85.0f * cap.getAbilityPower()));
            this.m_21153_(this.m_21233_());
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_9236_().m_7967_((Entity)new WoodShieldSegmentEntity((LivingEntity)this));
    }

    @NotNull
    public Vec3 m_20184_() {
        return Vec3.f_82478_;
    }

    public boolean m_20067_() {
        return true;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return super.m_6972_(pPose);
        }
        return EntityDimensions.m_20398_((float)owner.m_20205_(), (float)owner.m_20206_()).m_20388_(2.0f);
    }

    public void m_8119_() {
        this.m_6210_();
        LivingEntity owner = this.getOwner();
        if (!(this.m_9236_().f_46443_ || owner != null && !owner.m_213877_() && owner.m_6084_() && JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.WOOD_SHIELD.get()))) {
            this.m_146870_();
        } else {
            super.m_8119_();
            if (owner != null && this.pos != null) {
                owner.m_6021_(this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_);
            }
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public void m_8107_() {
    }

    public boolean m_6094_() {
        return false;
    }

    protected boolean m_20073_() {
        return false;
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public boolean m_5830_() {
        return false;
    }

    public boolean m_21532_() {
        return true;
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.pos != null) {
            pCompound.m_128347_("pos_x", this.pos.f_82479_);
            pCompound.m_128347_("pos_y", this.pos.f_82480_);
            pCompound.m_128347_("pos_z", this.pos.f_82481_);
        }
        if (this.ownerUUID != null) {
            pCompound.m_128362_("owner", this.ownerUUID);
        }
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.pos = new Vec3(pCompound.m_128459_("pos_x"), pCompound.m_128459_("pos_y"), pCompound.m_128459_("pos_z"));
        if (pCompound.m_128403_("owner")) {
            this.ownerUUID = pCompound.m_128342_("owner");
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        LivingEntity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? 0 : entity.m_19879_());
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        LivingEntity owner = (LivingEntity)this.m_9236_().m_6815_(pPacket.m_131509_());
        if (owner != null) {
            this.setOwner(owner);
        }
    }
}

