/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EelGrappleProjectile
extends JujutsuProjectile
implements GeoEntity {
    public static final float SPEED = 12.0f;
    private static final int DURATION = 80;
    public static final double RANGE = 40.0;
    private LivingEntity pulled;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public EelGrappleProjectile(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
    }

    public EelGrappleProjectile(LivingEntity owner) {
        this((EntityType<? extends Projectile>)((EntityType)JJKEntities.EEL_GRAPPLE.get()), owner.m_9236_());
        this.m_5602_((Entity)owner);
        Vec3 spawn = new Vec3(owner.m_20185_(), owner.m_20186_() + (double)(owner.m_20206_() / 2.0f) - (double)(this.m_20206_() / 2.0f), owner.m_20189_());
        this.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
        this.m_20256_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82490_(12.0));
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        super.m_8060_(pResult);
        this.m_146870_();
    }

    @Override
    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        Entity owner = this.m_19749_();
        if (owner == null) {
            this.m_146870_();
        }
        if ((target = RotationUtil.getExpandedLookAt(owner, 40.0)) == null) {
            return;
        }
        this.pulled = target;
        this.m_20256_(Vec3.f_82478_);
        if (this.getTime() >= 80) {
            this.m_146870_();
            return;
        }
        if (owner == null) {
            return;
        }
        if (this.pulled != null) {
            this.pulled.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STAGGER.get(), 2, 0, false, false, false));
            if (this.pulled.m_213877_() || this.pulled.m_21224_()) {
                this.m_146870_();
                return;
            }
            this.m_6034_(this.pulled.m_20185_(), this.pulled.m_20186_() + (double)(this.pulled.m_20206_() / 2.0f), this.pulled.m_20189_());
            this.pulled.m_20256_(owner.m_20182_().m_82546_(this.pulled.m_20182_()).m_82541_());
            this.pulled.f_19864_ = true;
            if ((double)this.m_20270_(owner) >= 40.0) {
                this.m_146870_();
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

