/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ExplosionHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.BetterSmokeParticle;
import radon.jujutsu_kaisen.client.particle.FireParticle;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.ParticleUtil;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FireballProjectile
extends JujutsuProjectile
implements GeoEntity {
    private static final RawAnimation SPIN = RawAnimation.begin().thenLoop("misc.spin");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final float DAMAGE = 30.0f;
    private static final float EXPLOSIVE_POWER = 2.5f;
    private static final float MAX_EXPLOSION = 15.0f;
    private static final float SPEED = 5.0f;
    public static final int DELAY = 20;

    public FireballProjectile(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public FireballProjectile(LivingEntity owner, float power) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.FIREBALL.get()), owner.m_9236_(), (Entity)owner, power);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        EntityUtil.offset((Entity)this, look, new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look));
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        Entity entity2 = this.m_19749_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity2;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (entity == owner && !cap.hasSelfHit()) {
            return;
        }
        entity.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.FIREBALL.get()), 30.0f * this.getPower());
    }

    protected void m_6532_(@NotNull HitResult result) {
        super.m_6532_(result);
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.m_5496_((SoundEvent)JJKSounds.FLAME_EXPLOSION.get(), 3.0f, 1.0f);
        Vec3 location = result.m_82450_();
        Vec3 center = new Vec3(location.f_82479_, location.f_82480_ + (double)(this.m_20206_() / 2.0f), location.f_82481_);
        int pillarCount = (int)((double)this.getFlamePillarRadius() * Math.PI * 2.0) * 8;
        for (int i = 0; i < pillarCount; ++i) {
            double theta = this.f_19796_.m_188500_() * Math.PI * 2.0;
            double phi = this.f_19796_.m_188500_() * Math.PI;
            double xOffset = (double)this.getFlamePillarRadius() * Math.sin(phi) * Math.cos(theta);
            double yOffset = (double)this.getFlamePillarRadius() * Math.sin(phi) * Math.sin(theta);
            double zOffset = (double)this.getFlamePillarRadius() * Math.cos(phi);
            int lifetime = 60;
            block9: for (int j = 0; j < 2; ++j) {
                double x = center.f_82479_ + xOffset * (double)this.getFlamePillarRadius() * this.f_19796_.m_188500_();
                double y = center.f_82480_ + yOffset * (double)(this.getFlamePillarRadius() * 10.0f) * this.f_19796_.m_188500_();
                double z = center.f_82481_ + zOffset * (double)this.getFlamePillarRadius() * this.f_19796_.m_188500_();
                Vec3 start = new Vec3(center.f_82479_ + xOffset * (double)(this.getFlamePillarRadius() * 0.1f), center.f_82480_, center.f_82481_ + zOffset * (double)(this.getFlamePillarRadius() * 0.1f));
                Vec3 end = new Vec3(x, y, z);
                Vec3 speed = start.m_82546_(end).m_82490_(1.0 / (double)lifetime * 2.0);
                switch (j) {
                    case 0: {
                        ParticleUtil.sendParticles((ServerLevel)this.m_9236_(), new FireParticle.FireParticleOptions(this.getFlamePillarRadius() * 0.3f, true, lifetime), true, start.f_82479_, start.f_82480_, start.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
                        continue block9;
                    }
                    case 1: {
                        ParticleUtil.sendParticles((ServerLevel)this.m_9236_(), new BetterSmokeParticle.BetterSmokeParticleOptions(this.getFlamePillarRadius() * 0.3f, lifetime), true, start.f_82479_, start.f_82480_, start.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
                    }
                }
            }
        }
        int shockwaveCount = (int)((double)(this.getFlamePillarRadius() * 2.0f) * Math.PI * 2.0) * 8;
        for (int i = 0; i < shockwaveCount; ++i) {
            double theta = this.f_19796_.m_188500_() * Math.PI * 2.0;
            double phi = this.f_19796_.m_188500_() * Math.PI;
            double xOffset = (double)(this.getFlamePillarRadius() * 2.0f) * Math.sin(phi) * Math.cos(theta);
            double zOffset = (double)(this.getFlamePillarRadius() * 2.0f) * Math.cos(phi);
            int lifetime = 60;
            block11: for (int j = 0; j < 2; ++j) {
                double x = center.f_82479_ + xOffset * (double)this.getFlamePillarRadius() * 2.0 * this.f_19796_.m_188500_();
                double z = center.f_82481_ + zOffset * (double)this.getFlamePillarRadius() * 2.0 * this.f_19796_.m_188500_();
                Vec3 start = new Vec3(center.f_82479_ + xOffset * (double)(this.getFlamePillarRadius() * 0.1f), center.f_82480_, center.f_82481_ + zOffset * (double)(this.getFlamePillarRadius() * 0.1f));
                Vec3 end = new Vec3(x, start.f_82480_, z);
                Vec3 speed = start.m_82546_(end).m_82490_(1.0 / (double)lifetime * 2.0);
                switch (j) {
                    case 0: {
                        ParticleUtil.sendParticles((ServerLevel)this.m_9236_(), new FireParticle.FireParticleOptions(this.getFlamePillarRadius() * 0.3f, true, lifetime), true, start.f_82479_, start.f_82480_, start.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
                        continue block11;
                    }
                    case 1: {
                        ParticleUtil.sendParticles((ServerLevel)this.m_9236_(), new BetterSmokeParticle.BetterSmokeParticleOptions(this.getFlamePillarRadius() * 0.3f, lifetime), true, start.f_82479_, start.f_82480_, start.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
                    }
                }
            }
        }
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            ExplosionHandler.spawn((ResourceKey<Level>)this.m_9236_().m_46472_(), location, this.getExplosionRadius(), 20, this.getPower() * 0.45f, owner, JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.FIREBALL.get()), true);
        }
        this.m_146870_();
    }

    private float getFlamePillarRadius() {
        return this.getExplosionRadius() * 0.25f;
    }

    private float getExplosionRadius() {
        return Math.min(15.0f, 2.5f * this.getPower());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            for (int i = 0; i < 2; ++i) {
                Vec3 dir = RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82548_().m_82490_(0.1);
                double dx = dir.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double dy = dir.f_82480_ + (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double dz = dir.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 0.5;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), dx, dy, dz);
            }
            if (this.getTime() < 20) {
                if (this.getTime() % 5 == 0) {
                    owner.m_6674_(InteractionHand.MAIN_HAND);
                }
                Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
                Vec3 spawn = new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look);
                this.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
                double d0 = look.m_165924_();
                this.m_146922_((float)(Mth.m_14136_((double)look.f_82479_, (double)look.f_82481_) * 57.2957763671875));
                this.m_146926_((float)(Mth.m_14136_((double)look.f_82480_, (double)d0) * 57.2957763671875));
                this.f_19859_ = this.m_146908_();
                this.f_19860_ = this.m_146909_();
            } else if (this.getTime() == 20) {
                this.m_20256_(RotationUtil.getTargetAdjustedLookAngle((Entity)owner).m_82490_(5.0));
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11874_, SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Spin", animationState -> animationState.setAndContinue(SPIN))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

