/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.RotationUtil;

public class LavaRockProjectile
extends JujutsuProjectile {
    private static final float DAMAGE = 10.0f;
    private static final float SPEED = 1.0f;
    @Nullable
    private UUID targetUUID;
    @Nullable
    private LivingEntity cachedTarget;

    public LavaRockProjectile(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public LavaRockProjectile(LivingEntity owner, float power, LivingEntity target) {
        super((EntityType<? extends Projectile>)((EntityType)JJKEntities.LAVA_ROCK.get()), owner.m_9236_(), (Entity)owner, power);
        this.setTarget(target);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        EntityUtil.offset((Entity)this, look, new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look));
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target != null) {
            this.targetUUID = target.m_20148_();
            this.cachedTarget = target;
        }
    }

    @Nullable
    public LivingEntity getTarget() {
        if (this.cachedTarget != null && !this.cachedTarget.m_213877_()) {
            return this.cachedTarget;
        }
        if (this.targetUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedTarget = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.targetUUID);
            return this.cachedTarget;
        }
        return null;
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.targetUUID != null) {
            pCompound.m_128362_("target", this.targetUUID);
        }
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128403_("target")) {
            this.targetUUID = pCompound.m_128342_("target");
        }
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity entity = pResult.m_82443_();
        Entity entity2 = this.m_19749_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity2;
        if (entity == owner) {
            return;
        }
        if (this.isDomain()) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            DomainExpansionEntity domain = cap.getSummonByClass(DomainExpansionEntity.class);
            entity.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)(domain == null ? this : domain), owner, (Ability)JJKAbilities.DEATH_SWARM.get()), 10.0f * this.getPower());
        } else {
            entity.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.DEATH_SWARM.get()), 10.0f * this.getPower());
        }
        this.m_146870_();
    }

    @Override
    public void m_8119_() {
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 0.0, 0.0, 0.0);
        if (!this.m_9236_().f_46443_) {
            LivingEntity target;
            LivingEntity owner;
            ISorcererData cap;
            DomainExpansionEntity domain;
            Entity entity = this.m_19749_();
            if (!(!(entity instanceof LivingEntity) || (domain = (cap = (ISorcererData)(owner = (LivingEntity)entity).getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow()).getSummonByClass(DomainExpansionEntity.class)) != null && domain.checkSureHitEffect() && JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.COFFIN_OF_THE_IRON_MOUNTAIN.get()))) {
                this.m_146870_();
            }
            if ((target = this.getTarget()) != null && !target.m_21224_() && !target.m_213877_()) {
                this.m_20256_(target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0).m_82546_(this.m_20182_()).m_82541_().m_82490_(1.0));
            } else {
                this.m_146870_();
            }
        }
        super.m_8119_();
    }
}

