/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.entity.effect.base.BeamEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.SorcererUtil;

public class MiniUzumakiProjectile
extends BeamEntity {
    public static final double RANGE = 24.0;
    private static final float MAX_POWER = 10.0f;

    public MiniUzumakiProjectile(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
    }

    public MiniUzumakiProjectile(LivingEntity owner, float power) {
        this((EntityType<? extends Projectile>)((EntityType)JJKEntities.MINI_UZUMAKI.get()), owner.m_9236_());
        this.m_5602_((Entity)owner);
        this.setPower(power);
        ISorcererData ownerCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        Entity weakest = null;
        for (Entity current : ownerCap.getSummons()) {
            if (!(current instanceof CursedSpirit)) continue;
            if (weakest == null) {
                weakest = current;
                continue;
            }
            ISorcererData weakestCap = (ISorcererData)weakest.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            ISorcererData currentCap = (ISorcererData)current.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (SorcererUtil.getGrade(currentCap.getExperience()).ordinal() >= SorcererUtil.getGrade(weakestCap.getExperience()).ordinal()) continue;
            weakest = current;
        }
        if (weakest != null) {
            ISorcererData weakestCap = (ISorcererData)weakest.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            float addPower = SorcererUtil.getPower(weakestCap.getExperience());
            if (addPower < 2.9f) {
                addPower /= 2.5f;
            }
            if (addPower > 3.85f) {
                addPower *= 1.25f;
            }
            this.setPower(Math.min(10.0f, (addPower /= 3.5f) + power));
            if (SorcererUtil.getGrade(weakestCap.getExperience()).ordinal() >= SorcererGrade.SEMI_GRADE_1.ordinal() && weakestCap.getTechnique() != null) {
                ownerCap.absorb(weakestCap.getTechnique());
                if (owner instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)owner;
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(ownerCap.serializeNBT()), player);
                }
            }
            weakest.m_146870_();
        }
    }

    @Override
    public int getFrames() {
        return 3;
    }

    @Override
    public float getScale() {
        return 1.0f;
    }

    @Override
    protected double getRange() {
        return 24.0;
    }

    @Override
    protected float getDamage() {
        return 18.0f;
    }

    @Override
    protected int getDuration() {
        return 20;
    }

    @Override
    public int getCharge() {
        return 10;
    }

    @Override
    @Nullable
    protected Ability getSource() {
        return (Ability)JJKAbilities.MINI_UZUMAKI.get();
    }
}

