/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile.base;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FishShikigamiProjectile
extends JujutsuProjectile
implements GeoEntity {
    private static final EntityDataAccessor<Float> DATA_OFFSET_X = SynchedEntityData.m_135353_(FishShikigamiProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_OFFSET_Y = SynchedEntityData.m_135353_(FishShikigamiProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final float DAMAGE = 13.0f;
    private int DELAY = 10;
    private static final int DURATION = 60;
    private static final double SPEED = 2.5;
    @Nullable
    private UUID targetUUID;
    @Nullable
    private LivingEntity cachedTarget;

    public FishShikigamiProjectile(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public FishShikigamiProjectile(EntityType<? extends Projectile> pType, LivingEntity owner, float power, LivingEntity target, float xOffset, float yOffset) {
        super(pType, owner.m_9236_(), (Entity)owner, power);
        this.setOffsetX(xOffset);
        this.setOffsetY(yOffset);
        this.setTarget(target);
        this.applyOffset();
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target != null) {
            this.targetUUID = target.m_20148_();
            this.cachedTarget = target;
        }
    }

    @Nullable
    public LivingEntity getTarget() {
        if (this.cachedTarget != null && !this.cachedTarget.m_213877_()) {
            return this.cachedTarget;
        }
        if (this.targetUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedTarget = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.targetUUID);
            return this.cachedTarget;
        }
        return null;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OFFSET_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_OFFSET_Y, (Object)Float.valueOf(0.0f));
    }

    private float getOffsetX() {
        return ((Float)this.f_19804_.m_135370_(DATA_OFFSET_X)).floatValue();
    }

    private void setOffsetX(float offsetX) {
        this.f_19804_.m_135381_(DATA_OFFSET_X, (Object)Float.valueOf(offsetX));
    }

    private float getOffsetY() {
        return ((Float)this.f_19804_.m_135370_(DATA_OFFSET_Y)).floatValue();
    }

    private void setOffsetY(float offsetY) {
        this.f_19804_.m_135381_(DATA_OFFSET_Y, (Object)Float.valueOf(offsetY));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("x_offset", this.getOffsetX());
        pCompound.m_128350_("y_offset", this.getOffsetY());
        if (this.targetUUID != null) {
            pCompound.m_128362_("target", this.targetUUID);
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setOffsetX(pCompound.m_128457_("x_offset"));
        this.setOffsetY(pCompound.m_128457_("y_offset"));
        if (pCompound.m_128403_("target")) {
            this.targetUUID = pCompound.m_128342_("target");
        }
    }

    protected boolean m_5603_(@NotNull Entity pTarget) {
        return !(pTarget instanceof FishShikigamiProjectile) && super.m_5603_(pTarget);
    }

    public void setDELAY(int num) {
        this.DELAY = num;
    }

    private void applyRotation() {
        LivingEntity target = this.getTarget();
        if (target == null) {
            return;
        }
        EntityUtil.rotation((Entity)this, target.m_20182_().m_82546_(this.m_20182_()));
    }

    private void applyOffset() {
        Entity entity = this.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        this.applyRotation();
        Vec3 spawn = new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82546_(look.m_82542_((double)this.m_20205_() * 3.0, 0.0, (double)this.m_20205_() * 3.0)).m_82549_(look).m_82549_(look.m_82524_(-90.0f).m_82490_((double)this.getOffsetX())).m_82549_(new Vec3(0.0, (double)this.getOffsetY(), 0.0));
        this.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        super.m_8060_(pResult);
        this.m_146870_();
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity entity = pResult.m_82443_();
        Entity entity2 = this.m_19749_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity2;
        if (entity == owner) {
            return;
        }
        if (entity != this.getTarget()) {
            return;
        }
        owner.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12228_, SoundSource.MASTER, 1.0f, 1.2f);
        if (this.isDomain()) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            DomainExpansionEntity domain = cap.getSummonByClass(DomainExpansionEntity.class);
            entity.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)(domain == null ? this : domain), owner, null), 13.0f * this.getPower());
        } else {
            entity.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.DEATH_SWARM.get()), 13.0f * this.getPower());
        }
        this.m_146870_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getTime() - this.DELAY >= 60) {
            this.m_146870_();
            return;
        }
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            if (this.getTime() == 1) {
                owner.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12537_, SoundSource.MASTER, 1.0f, 0.8f + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 0.2f);
            }
            if (this.getTime() == this.DELAY) {
                owner.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11777_, SoundSource.MASTER, 0.8f, 1.0f + (HelperMethods.RANDOM.m_188501_() - 0.5f) * 0.2f);
            }
            if (this.getTime() < this.DELAY) {
                if (!owner.m_6084_()) {
                    this.m_146870_();
                } else {
                    if (this.getTime() % 5 == 0) {
                        owner.m_6674_(InteractionHand.MAIN_HAND);
                    }
                    this.applyOffset();
                }
            } else if (this.getTime() >= this.DELAY) {
                this.applyRotation();
                if (!this.m_9236_().f_46443_) {
                    LivingEntity target = this.getTarget();
                    if (target != null && !target.m_21224_() && !target.m_213877_()) {
                        this.m_20256_(target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0).m_82546_(this.m_20182_()).m_82541_().m_82490_(2.5));
                    } else {
                        this.m_146870_();
                    }
                }
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

