/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.ten_shadows;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.entity.ai.goal.BetterFollowOwnerGoal;
import radon.jujutsu_kaisen.entity.ai.goal.SorcererGoal;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.base.TenShadowsSummon;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DivineDogEntity
extends TenShadowsSummon
implements PlayerRideable {
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(DivineDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_LEAP = SynchedEntityData.m_135353_(DivineDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_RITUAL = SynchedEntityData.m_135353_(DivineDogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("move.run");
    private static final RawAnimation LEAP = RawAnimation.begin().thenPlay("attack.leap");
    private static final RawAnimation HOWL = RawAnimation.begin().thenPlayAndHold("misc.howl");
    private static final int LEAP_DURATION = 10;

    public DivineDogEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public DivineDogEntity(EntityType<? extends TamableAnimal> type, LivingEntity owner, boolean ritual, Variant variant) {
        super(type, owner.m_9236_());
        this.m_7105_(true);
        this.setOwner(owner);
        Vec3 direction = RotationUtil.calculateViewVector(0.0f, owner.m_146908_());
        Vec3 pos = ritual ? owner.m_20182_() : owner.m_20182_().m_82546_(direction.m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_())).m_82549_(direction.m_82524_(90.0f).m_82490_(this.getVariant() == Variant.WHITE ? -0.45 : 0.45));
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, owner.m_146908_(), owner.m_146909_());
        this.f_20886_ = this.f_20885_ = this.m_146908_();
        this.setVariant(variant);
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        this.f_21342_ = new MoveControl((Mob)this);
    }

    public boolean m_20147_() {
        return (Integer)this.f_19804_.m_135370_(DATA_RITUAL) > 0 || super.m_20147_();
    }

    @Override
    protected boolean isCustom() {
        return true;
    }

    @Override
    protected boolean canFly() {
        return false;
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return false;
    }

    @Override
    public boolean canJump() {
        return false;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    protected void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)variant.ordinal());
    }

    public void setRitual(int duration) {
        this.f_19804_.m_135381_(DATA_RITUAL, (Object)duration);
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (pPlayer == this.m_269323_() && !this.m_20160_()) {
            if (pPlayer.m_20329_((Entity)this)) {
                pPlayer.m_146922_(this.m_146908_());
                pPlayer.m_146926_(this.m_146909_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    private Vec2 getRiddenRotation(LivingEntity pEntity) {
        return new Vec2(pEntity.m_146909_() * 0.5f, pEntity.m_146908_());
    }

    protected float m_245547_(@NotNull Player pPlayer) {
        return (float)this.m_21133_(Attributes.f_22279_) * 1.0f;
    }

    protected void m_274498_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)pPlayer);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20885_ = this.f_20886_ = this.m_146908_();
        this.f_20883_ = this.f_20886_;
        this.f_19859_ = this.f_20886_;
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        float f = pPlayer.f_20900_ * 0.5f;
        float f1 = pPlayer.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    protected boolean shouldToggleOnDeath() {
        return false;
    }

    protected void m_8099_() {
        int goal = 1;
        int target = 1;
        this.f_21345_.m_25352_(goal++, (Goal)new FloatGoal((Mob)this));
        if (this.hasMeleeAttack()) {
            this.f_21345_.m_25352_(goal++, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        }
        this.f_21345_.m_25352_(goal++, (Goal)new CustomLeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(goal++, (Goal)new SorcererGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(target++, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(goal++, (Goal)new BetterFollowOwnerGoal(this, 1.0, 25.0f, 10.0f, this.canFly()));
        this.f_21346_.m_25352_(target++, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(target, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(goal, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        LivingEntity target = this.m_5448_();
        GroundPathNavigation navigation = new GroundPathNavigation((Mob)this, pLevel);
        navigation.m_26477_(false);
        navigation.m_7008_(false);
        navigation.m_148214_(true);
        return navigation;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22268_(Attributes.f_22279_, 0.42900000000000005).m_22268_(Attributes.f_22276_, 36.0).m_22268_(Attributes.f_22284_, 14.0).m_22268_(Attributes.f_22281_, 21.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)Variant.WHITE.ordinal());
        this.f_19804_.m_135372_(DATA_LEAP, (Object)0);
        this.f_19804_.m_135372_(DATA_RITUAL, (Object)0);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("variant", ((Integer)this.f_19804_.m_135370_(DATA_VARIANT)).intValue());
        pCompound.m_128405_("ritual", ((Integer)this.f_19804_.m_135370_(DATA_RITUAL)).intValue());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)pCompound.m_128451_("variant"));
        this.f_19804_.m_135381_(DATA_RITUAL, (Object)pCompound.m_128451_("ritual"));
    }

    private PlayState walkRunIdlePredicate(AnimationState<DivineDogEntity> animationState) {
        if (animationState.isMoving()) {
            return animationState.setAndContinue(this.m_20142_() ? RUN : WALK);
        }
        return animationState.setAndContinue(IDLE);
    }

    private PlayState leapPredicate(AnimationState<DivineDogEntity> animationState) {
        if ((Integer)this.f_19804_.m_135370_(DATA_LEAP) > 0) {
            return animationState.setAndContinue(LEAP);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private PlayState howlPredicate(AnimationState<DivineDogEntity> animationState) {
        if ((Integer)this.f_19804_.m_135370_(DATA_RITUAL) > 0) {
            return animationState.setAndContinue(HOWL);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Walk/Run/Idle", this::walkRunIdlePredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Leap", this::leapPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Howl", this::howlPredicate)});
    }

    public Variant getVariant() {
        return Variant.values()[(Integer)this.f_19804_.m_135370_(DATA_VARIANT)];
    }

    @Override
    public Summon<?> getAbility() {
        return (Summon)JJKAbilities.DIVINE_DOGS.get();
    }

    @Override
    protected void m_8024_() {
        int leap;
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target != null) {
            this.f_21342_.m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), (double)0.9f);
        }
        if ((leap = ((Integer)this.f_19804_.m_135370_(DATA_LEAP)).intValue()) > 0) {
            this.f_19804_.m_135381_(DATA_LEAP, (Object)(--leap));
        }
    }

    @Override
    public void m_8119_() {
        int ritual = (Integer)this.f_19804_.m_135370_(DATA_RITUAL);
        if (ritual > 0) {
            this.f_19804_.m_135381_(DATA_RITUAL, (Object)(--ritual));
            if (ritual == 0) {
                this.m_146870_();
            }
        } else {
            super.m_8119_();
        }
    }

    public static enum Variant {
        WHITE,
        BLACK;

    }

    private class CustomLeapAtTargetGoal
    extends LeapAtTargetGoal {
        public CustomLeapAtTargetGoal(Mob pMob, float pYd) {
            super(pMob, pYd);
        }

        public void m_8056_() {
            super.m_8056_();
            DivineDogEntity.this.f_19804_.m_135381_(DATA_LEAP, (Object)10);
        }
    }
}

