/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.ten_shadows;

import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ExplosionHandler;
import radon.jujutsu_kaisen.ability.AbilityHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.base.IRightClickInputListener;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.base.TenShadowsSummon;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class MaxElephantEntity
extends TenShadowsSummon
implements PlayerRideable,
IRightClickInputListener {
    private static final double EXPLOSION_FALL_DISTANCE = 10.0;
    private static final int EXPLOSION_DURATION = 20;
    private static final float EXPLOSION_POWER = 15.0f;
    private static final EntityDataAccessor<Boolean> DATA_SHOOTING = SynchedEntityData.m_135353_(MaxElephantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("move.run");
    private static final RawAnimation SWING = RawAnimation.begin().thenPlay("attack.swing");
    private static final RawAnimation SHOOT = RawAnimation.begin().thenLoop("attack.shoot");
    private int riding;

    public MaxElephantEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    protected boolean canFly() {
        return false;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return false;
    }

    @Override
    public boolean canJump() {
        return false;
    }

    public MaxElephantEntity(LivingEntity owner, boolean tame) {
        this((EntityType<? extends TamableAnimal>)((EntityType)JJKEntities.MAX_ELEPHANT.get()), owner.m_9236_());
        this.m_7105_(tame);
        this.setOwner(owner);
        Vec3 direction = RotationUtil.calculateViewVector(0.0f, owner.m_146908_());
        Vec3 pos = owner.m_20182_().m_82546_(direction.m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_()));
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, owner.m_146908_(), owner.m_146909_());
        this.f_20886_ = this.f_20885_ = this.m_146908_();
        this.f_21342_ = new MoveControl((Mob)this);
    }

    public double m_6048_() {
        return this.m_20206_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SHOOTING, (Object)false);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        boolean result = super.m_142535_(pFallDistance, pMultiplier, pSource);
        if (result && (double)pFallDistance >= 10.0) {
            ExplosionHandler.spawn((ResourceKey<Level>)this.m_9236_().m_46472_(), this.m_20182_(), 15.0f, 20, (LivingEntity)this, this.m_269291_().m_269333_((LivingEntity)this), false);
        }
        return result;
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (pPlayer == this.m_269323_() && this.m_21824_() && !this.m_20160_()) {
            this.riding = this.f_19797_;
            if (pPlayer.m_20329_((Entity)this)) {
                pPlayer.m_146922_(this.m_146908_());
                pPlayer.m_146926_(this.m_146909_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    private Vec2 getRiddenRotation(LivingEntity pEntity) {
        return new Vec2(pEntity.m_146909_() * 0.5f, pEntity.m_146908_());
    }

    protected float m_245547_(@NotNull Player pPlayer) {
        return (float)this.m_21133_(Attributes.f_22279_) * 0.25f;
    }

    protected void m_274498_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)pPlayer);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20885_ = this.f_20886_ = this.m_146908_();
        this.f_20883_ = this.f_20886_;
        this.f_19859_ = this.f_20886_;
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        float f = pPlayer.f_20900_ * 0.5f;
        float f1 = pPlayer.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    public float getStepHeight() {
        return 2.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22268_(Attributes.f_22279_, 0.33).m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22284_, 14.0).m_22268_(Attributes.f_22281_, 21.0);
    }

    private PlayState walkRunIdlePredicate(AnimationState<MaxElephantEntity> animationState) {
        if (animationState.isMoving()) {
            return animationState.setAndContinue(this.m_20142_() ? RUN : WALK);
        }
        return animationState.setAndContinue(IDLE);
    }

    private PlayState swingPredicate(AnimationState<MaxElephantEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(SWING);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private PlayState shootPredicate(AnimationState<MaxElephantEntity> animationState) {
        if (((Boolean)this.f_19804_.m_135370_(DATA_SHOOTING)).booleanValue()) {
            return animationState.setAndContinue(SHOOT);
        }
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Walk/Run/Idle", this::walkRunIdlePredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swing", this::swingPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Shoot", this::shootPredicate)});
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        LivingEntity target = this.m_5448_();
        GroundPathNavigation navigation = new GroundPathNavigation((Mob)this, pLevel);
        navigation.m_26477_(false);
        navigation.m_7008_(false);
        navigation.m_148214_(true);
        return navigation;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.f_19804_.m_135381_(DATA_SHOOTING, (Object)JJKAbilities.isChanneling((LivingEntity)this, (Ability)JJKAbilities.WATER.get()));
        LivingEntity target = this.m_5448_();
        if (target != null) {
            this.f_21342_.m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 0.75);
        }
    }

    @Override
    @NotNull
    public List<Ability> getCustom() {
        return List.of((Ability)JJKAbilities.WATER.get());
    }

    @Override
    public Summon<?> getAbility() {
        return (Summon)JJKAbilities.MAX_ELEPHANT.get();
    }

    @Override
    public void setDown(boolean down) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.f_19797_ - this.riding < 20) {
            return;
        }
        boolean channelling = JJKAbilities.isChanneling((LivingEntity)this, (Ability)JJKAbilities.WATER.get());
        if (down) {
            if (!channelling) {
                AbilityHandler.trigger((LivingEntity)this, (Ability)JJKAbilities.WATER.get());
            }
        } else if (channelling) {
            AbilityHandler.untrigger((LivingEntity)this, (Ability)JJKAbilities.WATER.get());
        }
    }
}

