/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.ten_shadows;

import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.base.IJumpInputListener;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.base.TenShadowsSummon;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class NueEntity
extends TenShadowsSummon
implements PlayerRideable,
IJumpInputListener {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    private static final RawAnimation FLY = RawAnimation.begin().thenLoop("move.fly");
    private static final RawAnimation SWING = RawAnimation.begin().thenLoop("attack.swing");
    private static final RawAnimation FLIGHT_FEET = RawAnimation.begin().thenLoop("misc.flight_feet");
    private static final RawAnimation GRAB_FEET = RawAnimation.begin().thenLoop("misc.grab_feet");
    private boolean jump;

    public NueEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public NueEntity(LivingEntity owner, boolean tame) {
        this((EntityType<? extends TamableAnimal>)((EntityType)JJKEntities.NUE.get()), owner.m_9236_());
        this.m_7105_(tame);
        this.setOwner(owner);
        Vec3 direction = RotationUtil.calculateViewVector(0.0f, owner.m_146908_());
        Vec3 pos = owner.m_20182_().m_82546_(direction.m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_()));
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, owner.m_146908_(), owner.m_146909_());
        this.f_20886_ = this.f_20885_ = this.m_146908_();
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    protected boolean canFly() {
        return true;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return false;
    }

    @Override
    public boolean canJump() {
        return false;
    }

    @Override
    @NotNull
    public List<Ability> getCustom() {
        return List.of((Ability)JJKAbilities.NUE_LIGHTNING.get());
    }

    protected float m_274460_() {
        return this.m_5448_() == null || this.m_20160_() ? 0.15f : 0.5f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22266_(Attributes.f_22280_).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22281_, 12.0);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, pLevel);
        navigation.m_26440_(false);
        navigation.m_7008_(true);
        navigation.m_26443_(true);
        return navigation;
    }

    private PlayState flyIdlePredicate(AnimationState<NueEntity> animationState) {
        if (animationState.isMoving()) {
            return animationState.setAndContinue(FLY);
        }
        return animationState.setAndContinue(IDLE);
    }

    private PlayState swingPredicate(AnimationState<NueEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(SWING);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private PlayState feetPredicate(AnimationState<NueEntity> animationState) {
        if (this.m_20160_()) {
            return animationState.setAndContinue(GRAB_FEET);
        }
        return animationState.setAndContinue(FLIGHT_FEET);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Fly/Idle", 5, this::flyIdlePredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swing", this::swingPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Feet", this::feetPredicate)});
    }

    @Override
    public Summon<?> getAbility() {
        return (Summon)JJKAbilities.NUE.get();
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (pPlayer == this.m_269323_() && this.m_21824_() && !this.m_20160_()) {
            if (pPlayer.m_20329_((Entity)this)) {
                pPlayer.m_146922_(this.m_146908_());
                pPlayer.m_146926_(this.m_146909_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public double m_6048_() {
        LivingEntity passenger = this.m_6688_();
        if (passenger == null) {
            return super.m_6048_();
        }
        return -passenger.m_20206_() + 0.8f;
    }

    @Override
    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        EntityDimensions dimensions = super.m_6972_(pPose);
        LivingEntity passenger = this.m_6688_();
        if (passenger != null) {
            return new EntityDimensions(dimensions.f_20377_, dimensions.f_20378_ + passenger.m_20206_(), dimensions.f_20379_);
        }
        return dimensions;
    }

    @NotNull
    protected AABB m_142242_() {
        AABB bounds = super.m_142242_();
        LivingEntity passenger = this.m_6688_();
        if (passenger != null) {
            return bounds.m_165887_(bounds.f_82289_ - (double)(passenger.m_20206_() / 2.0f) - 0.4).m_165893_(bounds.f_82292_ - (double)passenger.m_20206_() + 0.4);
        }
        return bounds;
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        if (this.m_20096_()) {
            return Vec3.f_82478_;
        }
        float f = pPlayer.f_20900_ * 0.5f;
        float f1 = pPlayer.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    private Vec2 getRiddenRotation(LivingEntity pEntity) {
        return new Vec2(pEntity.m_146909_() * 0.5f, pEntity.m_146908_());
    }

    public boolean m_20068_() {
        return !this.m_20160_() && super.m_20068_();
    }

    protected void m_274498_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)pPlayer);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        Vec3 movement = this.m_20184_();
        if (this.jump) {
            this.m_20256_(movement.m_82520_(0.0, (double)this.m_274460_(), 0.0));
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target != null) {
            this.f_21342_.m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), (double)0.8f);
        }
    }

    @Override
    public void setJump(boolean jump) {
        this.jump = jump;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_6210_();
    }

    static enum Flight {
        ASCEND,
        SPRINT,
        NORMAL;

    }
}

