/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.event;

import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.client.particle.LightningParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.projectile.ThrownChainProjectile;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.item.cursed_tool.DragonBoneItem;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.CuriosUtil;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class WeaponEventHandler {

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class WeaponEventHandlerForgeEvents {
        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            block12: {
                ISorcererData attackerCap;
                LivingEntity victim;
                LivingEntity attacker;
                block14: {
                    block13: {
                        ItemStack itemStack;
                        DamageSource source = event.getSource();
                        Entity entity = source.m_7639_();
                        if (!(entity instanceof LivingEntity)) {
                            return;
                        }
                        attacker = (LivingEntity)entity;
                        victim = event.getEntity();
                        if (victim.m_9236_().f_46443_) {
                            return;
                        }
                        Entity entity2 = source.m_7640_();
                        if (entity2 instanceof ThrownChainProjectile) {
                            ThrownChainProjectile chain = (ThrownChainProjectile)entity2;
                            itemStack = chain.getStack();
                        } else {
                            itemStack = attacker.m_21120_(InteractionHand.MAIN_HAND);
                        }
                        ItemStack stack = itemStack;
                        ArrayList<Item> stacks = new ArrayList<Item>();
                        stacks.add(stack.m_41720_());
                        stacks.addAll(CuriosUtil.findSlots(attacker, attacker.m_5737_() == HumanoidArm.RIGHT ? "right_hand" : "left_hand").stream().map(ItemStack::m_41720_).toList());
                        if (!HelperMethods.isMelee(source)) break block12;
                        if (stacks.contains(JJKItems.PLAYFUL_CLOUD.get())) {
                            Vec3 pos = attacker.m_146892_().m_82549_(RotationUtil.getTargetAdjustedLookAngle((Entity)attacker));
                            attacker.m_9236_().m_254877_((Entity)attacker, attacker.m_269291_().m_269036_((Entity)attacker, null), null, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.0f, false, Level.ExplosionInteraction.NONE);
                        }
                        if (stacks.contains(JJKItems.INVERTED_SPEAR_OF_HEAVEN.get()) && (!((Boolean)ConfigHolder.SERVER.hrRequiredForISOH.get()).booleanValue() || JJKAbilities.hasTrait(attacker, Trait.HEAVENLY_RESTRICTION))) {
                            victim.getCapability(SorcererDataHandler.INSTANCE).ifPresent(cap -> {
                                cap.setDisable(5);
                                if (cap.hasTechnique(CursedTechnique.BRAIN_TRANSPLANT)) {
                                    victim.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), 4, 0, false, false, false));
                                }
                                if (victim instanceof ServerPlayer) {
                                    ServerPlayer player = (ServerPlayer)victim;
                                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
                                }
                            });
                        }
                        if (!stacks.contains(JJKItems.KAMUTOKE_DAGGER.get()) || !attacker.getCapability(SorcererDataHandler.INSTANCE).isPresent()) break block12;
                        attackerCap = (ISorcererData)attacker.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                        if (!(attacker instanceof Player)) break block13;
                        Player player = (Player)attacker;
                        if (player.m_150110_().f_35937_) break block14;
                    }
                    float cost = 20.0f;
                    if (attackerCap.getEnergy() < cost) {
                        return;
                    }
                    attackerCap.useEnergy(cost);
                }
                victim.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), 5, 0, false, false, false));
                attacker.m_9236_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), SoundEvents.f_12089_, SoundSource.MASTER, 1.0f, 0.5f + HelperMethods.RANDOM.m_188501_() * 0.2f);
                for (int i = 0; i < 32; ++i) {
                    double offsetX = HelperMethods.RANDOM.m_188583_() * 1.5;
                    double offsetY = HelperMethods.RANDOM.m_188583_() * 1.5;
                    double offsetZ = HelperMethods.RANDOM.m_188583_() * 1.5;
                    ((ServerLevel)attacker.m_9236_()).m_8767_((ParticleOptions)new LightningParticle.LightningParticleOptions(ParticleColors.getCursedEnergyColorBright(attacker), 0.5f, 1), victim.m_20185_() + offsetX, victim.m_20186_() + offsetY, victim.m_20189_() + offsetZ, 0, 0.0, 0.0, 0.0, 0.0);
                }
                if (attacker instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)attacker;
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(attackerCap.serializeNBT()), player);
                }
            }
        }

        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent event) {
            ItemStack itemStack;
            DamageSource source = event.getSource();
            Entity entity = source.m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            Entity entity2 = source.m_7640_();
            if (entity2 instanceof ThrownChainProjectile) {
                ThrownChainProjectile chain = (ThrownChainProjectile)entity2;
                itemStack = chain.getStack();
            } else {
                itemStack = attacker.m_21120_(InteractionHand.MAIN_HAND);
            }
            ItemStack stack = itemStack;
            ArrayList<Item> stacks = new ArrayList<Item>();
            stacks.add(stack.m_41720_());
            stacks.addAll(CuriosUtil.findSlots(attacker, attacker.m_5737_() == HumanoidArm.RIGHT ? "right_hand" : "left_hand").stream().map(ItemStack::m_41720_).toList());
            if (HelperMethods.isMelee(source)) {
                if (stacks.contains(JJKItems.SPLIT_SOUL_KATANA.get()) && JJKAbilities.hasTrait(attacker, Trait.HEAVENLY_RESTRICTION) && !source.m_276093_(JJKDamageSources.SPLIT_SOUL_KATANA) && victim.m_6469_(JJKDamageSources.splitSoulKatanaAttack(attacker), event.getAmount() * 1.0f)) {
                    event.setAmount(event.getAmount() * 0.1f);
                }
                if (stacks.contains(JJKItems.STEEL_GAUNTLET.get())) {
                    event.setAmount(event.getAmount() * 1.1f);
                }
                if (stacks.contains(JJKItems.PLAYFUL_CLOUD.get())) {
                    if (JJKAbilities.hasTrait(attacker, Trait.HEAVENLY_RESTRICTION)) {
                        event.setAmount(event.getAmount() * 1.2f);
                    } else {
                        event.setAmount(event.getAmount() * 1.05f);
                    }
                }
            }
            if (stacks.contains(JJKItems.DRAGON_BONE.get()) && (JJKAbilities.hasToggled(victim, (Ability)JJKAbilities.CURSED_ENERGY_FLOW.get()) || JJKAbilities.hasToggled(victim, (Ability)JJKAbilities.FALLING_BLOSSOM_EMOTION.get()))) {
                float Amount = Math.min(6.0f, event.getAmount() * 0.8f);
                DragonBoneItem.addEnergy(stack, Amount);
            }
        }
    }
}

