/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.item.armor;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.client.render.item.armor.InventoryCurseRenderer;
import radon.jujutsu_kaisen.sound.JJKSounds;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class InventoryCurseItem
extends ArmorItem
implements GeoItem,
MenuProvider,
ICurioItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final int SIZE = 9;

    public InventoryCurseItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    @NotNull
    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        return slotContext.entity() instanceof Player ? super.getDropRule(slotContext, source, lootingLevel, recentlyHit, stack) : ICurio.DropRule.DESTROY;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private InventoryCurseRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new InventoryCurseRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)String.format("%s.desc", this.m_5524_()));
    }

    private static void ensureSize(ListTag list) {
        while (list.size() < 9) {
            list.add((Object)new CompoundTag());
        }
    }

    private static ItemStack findEquippedCurse(Player player) {
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        if (chest.m_41720_() instanceof InventoryCurseItem) {
            return chest;
        }
        LazyOptional optional = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (!optional.isPresent()) {
            return ItemStack.f_41583_;
        }
        ICuriosItemHandler handler = optional.resolve().orElse(null);
        if (handler == null) {
            return ItemStack.f_41583_;
        }
        for (SlotResult result : handler.findCurios(item -> item.m_41720_() instanceof InventoryCurseItem)) {
            if (result.stack().m_41619_()) continue;
            return result.stack();
        }
        return ItemStack.f_41583_;
    }

    public static void addItem(ItemStack inventory, int slot, ItemStack stack) {
        CompoundTag nbt = inventory.m_41784_();
        ListTag itemsTag = nbt.m_128437_("items", 10);
        InventoryCurseItem.ensureSize(itemsTag);
        itemsTag.set(slot, (Tag)stack.m_41739_(new CompoundTag()));
        nbt.m_128365_("items", (Tag)itemsTag);
    }

    public static void removeItem(ItemStack inventory, int slot) {
        CompoundTag nbt = inventory.m_41784_();
        ListTag itemsTag = nbt.m_128437_("items", 10);
        InventoryCurseItem.ensureSize(itemsTag);
        itemsTag.set(slot, (Tag)new CompoundTag());
        nbt.m_128365_("items", (Tag)itemsTag);
    }

    public static void clear(ItemStack inventory) {
        CompoundTag nbt = inventory.m_41784_();
        ListTag list = new ListTag();
        InventoryCurseItem.ensureSize(list);
        nbt.m_128365_("items", (Tag)list);
    }

    public static ItemStack getItem(ItemStack inventory, int slot) {
        CompoundTag nbt = inventory.m_41784_();
        ListTag itemsTag = nbt.m_128437_("items", 10);
        InventoryCurseItem.ensureSize(itemsTag);
        return ItemStack.m_41712_((CompoundTag)itemsTag.m_128728_(slot));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInv, final @NotNull Player player) {
        final ItemStack inventoryItem = InventoryCurseItem.findEquippedCurse(player);
        if (inventoryItem.m_41619_()) {
            return null;
        }
        final CompoundTag nbt = inventoryItem.m_41784_();
        ListTag itemsTag = nbt.m_128437_("items", 10);
        InventoryCurseItem.ensureSize(itemsTag);
        final AtomicInteger previousCount = new AtomicInteger(itemsTag.size());
        SimpleContainer container = new SimpleContainer(9){

            public void m_6596_() {
                super.m_6596_();
                ListTag tag = new ListTag();
                for (int i = 0; i < this.m_6643_(); ++i) {
                    ItemStack stack = this.m_8020_(i);
                    tag.add((Object)(stack.m_41619_() ? new CompoundTag() : stack.m_41739_(new CompoundTag())));
                }
                nbt.m_128365_("items", (Tag)tag);
                inventoryItem.m_41751_(nbt);
                int current = tag.size();
                if (current > previousCount.get()) {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)JJKSounds.SWALLOW.get(), SoundSource.MASTER, 1.0f, 1.0f);
                }
                previousCount.set(current);
            }
        };
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemsTag.m_128728_(i));
            container.m_6836_(i, stack);
        }
        return new ChestMenu(MenuType.f_39957_, id, playerInv, (Container)container, 1);
    }
}

