/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.item.veil;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.block.entity.VeilRodBlockEntity;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.item.veil.modifier.Modifier;
import radon.jujutsu_kaisen.item.veil.modifier.ModifierUtils;

public class VeilRodItem
extends BlockItem {
    public VeilRodItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        ArrayList<Object> modifiers = new ArrayList<Object>();
        modifiers.add(CommonComponents.f_237098_);
        modifiers.add(Component.m_237115_((String)String.format("item.%s.veil_rod_item.modifiers", "jujutsu_kaisen")).m_130940_(ChatFormatting.DARK_BLUE));
        boolean success = false;
        for (Modifier modifier : VeilRodItem.getModifiers(pStack)) {
            if (modifier.getType() == Modifier.Type.NONE) continue;
            modifiers.add(CommonComponents.m_264333_().m_7220_(modifier.getComponent()));
            success = true;
        }
        if (success) {
            pTooltip.addAll(modifiers);
        }
    }

    public static List<Modifier> getModifiers(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        return ModifierUtils.getModifiers(nbt.m_128469_("BlockEntityTag"));
    }

    public static void setModifier(ItemStack stack, int index, Modifier modifier) {
        CompoundTag nbt = stack.m_41784_();
        CompoundTag tag = nbt.m_128469_("BlockEntityTag");
        ModifierUtils.setModifier(tag, index, modifier);
        nbt.m_128365_("BlockEntityTag", (Tag)tag);
    }

    protected boolean m_7274_(@NotNull BlockPos pPos, @NotNull Level pLevel, @Nullable Player pPlayer, @NotNull ItemStack pStack, @NotNull BlockState pState) {
        BlockEntity blockEntity;
        if (pPlayer != null && (blockEntity = pLevel.m_7702_(pPos)) instanceof VeilRodBlockEntity) {
            VeilRodBlockEntity be = (VeilRodBlockEntity)blockEntity;
            be.setOwner(pPlayer.m_20148_());
            ISorcererData cap = (ISorcererData)pPlayer.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            be.setExperience(cap.getExperience());
        }
        return super.m_7274_(pPos, pLevel, pPlayer, pStack, pState);
    }
}

