/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.mixin.common;

import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.ITransformation;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.visual.ClientVisualHandler;
import radon.jujutsu_kaisen.effect.JJKEffects;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    public abstract void m_142687_(Entity.RemovalReason var1);

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Inject(method={"isFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    public void isFallFlying(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.m_9236_().f_46443_) {
            ClientVisualHandler.ClientData data = ClientVisualHandler.get((Entity)((LivingEntity)this));
            if (data == null) {
                return;
            }
            for (Ability ability : data.toggled) {
                ITransformation transformation;
                if (!(ability instanceof ITransformation) || !(transformation = (ITransformation)((Object)ability)).getItem().canElytraFly(transformation.getItem().m_7968_(), entity)) continue;
                cir.setReturnValue((Object)true);
            }
        } else {
            if (!entity.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData cap = (ISorcererData)entity.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            for (Ability ability : cap.getToggled()) {
                ITransformation transformation;
                if (!(ability instanceof ITransformation) || !(transformation = (ITransformation)((Object)ability)).getItem().canElytraFly(transformation.getItem().m_7968_(), entity)) continue;
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getFriction(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;)F"))
    public float travel(BlockState instance, LevelReader levelReader, BlockPos blockPos, Entity entity) {
        LivingEntity living;
        if (!(entity instanceof LivingEntity && JJKAbilities.hasToggled(living = (LivingEntity)entity, (Ability)JJKAbilities.DISMANTLE_SKATING.get()) && instance.m_60819_().m_76178_())) {
            return instance.getFriction(levelReader, blockPos, entity);
        }
        return 1.0789f;
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;travel(Lnet/minecraft/world/phys/Vec3;)V"))
    public void travel(LivingEntity instance, Vec3 f4) {
        if (this.m_21023_((MobEffect)JJKEffects.STUN.get())) {
            instance.m_7023_(Vec3.f_82478_);
            return;
        }
        instance.m_7023_(f4);
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="HEAD")}, cancellable=true)
    public void jumpFromGround(CallbackInfo ci) {
        if (this.m_21023_((MobEffect)JJKEffects.STUN.get())) {
            ci.cancel();
        }
    }

    @Inject(method={"jumpInLiquid"}, at={@At(value="HEAD")}, cancellable=true)
    public void jumpInLiquid(CallbackInfo ci) {
        if (this.m_21023_((MobEffect)JJKEffects.STUN.get())) {
            ci.cancel();
        }
    }
}

