/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.network.packet.c2s;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.capability.data.sorcerer.AbsorbedCurse;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;

public class CurseSummonC2SPacket {
    private final UUID curseId;

    public CurseSummonC2SPacket(UUID curseId) {
        this.curseId = curseId;
    }

    public CurseSummonC2SPacket(FriendlyByteBuf buf) {
        this.curseId = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.curseId);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            ISorcererData cap = (ISorcererData)sender.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (cap == null) {
                return;
            }
            AbsorbedCurse curse = cap.getCurses().stream().filter(c -> c.getUUID().equals(this.curseId)).findFirst().orElse(null);
            if (curse != null) {
                JJKAbilities.summonCurse((LivingEntity)sender, curse, true);
            }
        });
        ctx.setPacketHandled(true);
    }
}

