/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.network.packet.c2s;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.chant.ServerChantHandler;

public class RemoveChantC2SPacket {
    private final ResourceLocation key;
    private final String chant;

    public RemoveChantC2SPacket(ResourceLocation key, String chant) {
        this.key = key;
        this.chant = chant;
    }

    public RemoveChantC2SPacket(FriendlyByteBuf buf) {
        this(buf.m_130281_(), buf.m_130277_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.key);
        buf.m_130070_(this.chant);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            assert (sender != null);
            Ability ability = JJKAbilities.getValue(this.key);
            if (ability == null) {
                return;
            }
            ISorcererData cap = (ISorcererData)sender.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            cap.removeChant(ability, this.chant);
            ServerChantHandler.clearMessages((LivingEntity)sender);
        });
        ctx.setPacketHandled(true);
    }
}

