/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.cursed_speech;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.CursedSpeechParticle;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;
import radon.jujutsu_kaisen.util.SorcererUtil;

public class Die
extends Ability {
    private static final double RANGE = 30.0;
    private static final double RADIUS = 2.5;
    private static final float DAMAGE = 28.0f;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return Die.getEntities((LivingEntity)owner).contains(target) && target != null && (owner.m_21223_() / owner.m_21233_() <= 0.25f || HelperMethods.RANDOM.m_188503_(10) == 0 && owner.m_142582_((Entity)target));
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    private static List<Entity> getEntities(LivingEntity owner) {
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 src = owner.m_146892_();
        AABB bounds = AABB.m_165882_((Vec3)src, (double)1.0, (double)1.0, (double)1.0).m_82369_(look.m_82490_(30.0)).m_82400_(2.5);
        return owner.m_9236_().m_6249_((Entity)owner, bounds, entity -> {
            LivingEntity living;
            return !(entity instanceof LivingEntity) || owner.m_6779_(living = (LivingEntity)entity);
        });
    }

    private static float calculateDamage(DamageSource source, LivingEntity target) {
        float damage = target.m_21233_();
        float armor = target.m_21230_();
        float toughness = (float)target.m_21133_(Attributes.f_22285_);
        float f = 2.0f + toughness / 4.0f;
        float f1 = Mth.m_14036_((float)(armor - damage / f), (float)(armor * 0.2f), (float)20.0f);
        damage /= 1.0f - f1 / 25.0f;
        MobEffectInstance instance = target.m_21124_(MobEffects.f_19606_);
        if (instance != null) {
            int resistance = instance.m_19564_();
            int i = (resistance + 1) * 5;
            int j = 25 - i;
            if (j == 0) {
                return damage;
            }
            float x = 25.0f / (float)j;
            damage *= x;
        }
        return damage;
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public void run(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 src = owner.m_146892_();
        int i = 1;
        while ((double)i < 37.0) {
            Vec3 dst = src.m_82549_(look.m_82490_((double)i));
            ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)new CursedSpeechParticle.CursedSpeechParticleOptions(new Vector3f(0.337f, 0.0f, 0.0f), (float)(src.m_82554_(dst) * 0.5)), dst.f_82479_, dst.f_82480_, dst.f_82481_, 0, 0.0, 0.0, 0.0, 1.0);
            ++i;
        }
        owner.m_9236_().m_6263_(null, src.f_82479_, src.f_82480_, src.f_82481_, (SoundEvent)JJKSounds.CURSED_SPEECH.get(), SoundSource.MASTER, 2.0f, 0.8f + HelperMethods.RANDOM.m_188501_() * 0.2f);
        ISorcererData ownerCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        for (Entity entity : Die.getEntities(owner)) {
            LivingEntity living;
            if (!(entity instanceof LivingEntity) || JJKAbilities.hasToggled(living = (LivingEntity)entity, (Ability)JJKAbilities.INFINITY.get())) continue;
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (living instanceof Player) {
                Player player = (Player)living;
                player.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.die", "jujutsu_kaisen"), (Object[])new Object[]{owner.m_7755_()}));
            }
            cap.delayTickEvent(() -> {
                if (entity != null) {
                    living.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, this), 28.0f * this.getPower(owner));
                    living.getCapability(SorcererDataHandler.INSTANCE).ifPresent(targetCap -> {
                        if (SorcererUtil.getGrade(ownerCap.getExperience()).ordinal() - SorcererUtil.getGrade(targetCap.getExperience()).ordinal() >= 2) {
                            JJKDamageSources.JujutsuDamageSource source = JJKDamageSources.jujutsuAttack(owner, this);
                            entity.m_6469_((DamageSource)source, Die.calculateDamage(source, living));
                        }
                    });
                }
            }, 15);
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 450.0f;
    }

    @Override
    public int getCooldown() {
        return 600;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.CURSED_SPEECH;
    }
}

