/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.shockwave;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.util.HelperMethods;

public class Shockwave
extends Ability {
    private static final double RADIUS = 15.0;
    private static final float DAMAGE = 14.0f;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return target != null && !target.m_21224_() && (double)owner.m_20270_((Entity)target) <= 15.0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Override
    public void run(LivingEntity owner) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_11913_, SoundSource.MASTER, 1.0f, 1.0f);
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        int current = 1;
        while ((double)current < 15.0) {
            int radius = ++current;
            cap.delayTickEvent(() -> {
                for (double phi = 0.0; phi < Math.PI * 2; phi += 0.5) {
                    double x = owner.m_20185_() + (double)radius * Math.cos(phi);
                    double y = owner.m_20186_();
                    double z = owner.m_20189_() + (double)radius * Math.sin(phi);
                    level2.m_8767_((ParticleOptions)ParticleTypes.f_123813_, x, y, z, 0, 0.0, HelperMethods.RANDOM.m_188500_(), 0.0, 1.0);
                }
                for (Entity entity : owner.m_9236_().m_45933_((Entity)owner, AABB.m_165882_((Vec3)owner.m_20182_(), (double)radius, (double)radius, (double)radius))) {
                    LivingEntity living;
                    if (!(entity instanceof LivingEntity) || !owner.m_6779_(living = (LivingEntity)entity) || (double)entity.m_20270_((Entity)owner) > 15.0 || !entity.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, this), 14.0f * this.getPower(owner))) continue;
                    entity.m_20256_(entity.m_20182_().m_82546_(owner.m_20182_()));
                }
            }, current);
        }
    }

    @Override
    public int getCooldown() {
        return 100;
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 50.0f;
    }
}

