/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.ability;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.AbilityHandler;
import radon.jujutsu_kaisen.ability.AbilityTriggerEvent;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.ITransformation;
import radon.jujutsu_kaisen.ability.misc.RCT1;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.JJKKeys;
import radon.jujutsu_kaisen.client.gui.overlay.AbilityOverlay;
import radon.jujutsu_kaisen.client.gui.screen.AbilityScreen;
import radon.jujutsu_kaisen.client.gui.screen.DomainScreen;
import radon.jujutsu_kaisen.client.gui.screen.ShadowInventoryScreen;
import radon.jujutsu_kaisen.client.visual.ClientVisualHandler;
import radon.jujutsu_kaisen.entity.base.IJumpInputListener;
import radon.jujutsu_kaisen.entity.base.IRightClickInputListener;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.c2s.JumpInputListenerC2SPacket;
import radon.jujutsu_kaisen.network.packet.c2s.RightClickInputListenerC2SPacket;
import radon.jujutsu_kaisen.network.packet.c2s.TriggerAbilityC2SPacket;
import radon.jujutsu_kaisen.network.packet.c2s.UntriggerAbilityC2SPacket;
import radon.jujutsu_kaisen.util.EntityUtil;

public class ClientAbilityHandler {
    @Nullable
    private static Ability channeled;
    @Nullable
    private static KeyMapping current;
    private static boolean isChanneling;
    private static boolean isRightDown;

    public static boolean isSuccess(Ability ability, Ability.Status status) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer owner = mc.f_91074_;
        if (owner == null) {
            return false;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        switch (status) {
            case ENERGY: {
                mc.f_91065_.m_93063_((Component)Component.m_237115_((String)String.format("ability.%s.fail.energy", "jujutsu_kaisen")), false);
                break;
            }
            case COOLDOWN: {
                mc.f_91065_.m_93063_((Component)Component.m_237110_((String)String.format("ability.%s.fail.cooldown", "jujutsu_kaisen"), (Object[])new Object[]{Math.max(1, cap.getRemainingCooldown(ability) / 20)}), false);
                break;
            }
            case BURNOUT: {
                mc.f_91065_.m_93063_((Component)Component.m_237110_((String)String.format("ability.%s.fail.burnout", "jujutsu_kaisen"), (Object[])new Object[]{cap.getBurnout() / 20}), false);
                break;
            }
            case DISABLE: {
                mc.f_91065_.m_93063_((Component)Component.m_237115_((String)String.format("ability.%s.fail.disable", "jujutsu_kaisen")), false);
                break;
            }
            case FAILURE: {
                mc.f_91065_.m_93063_((Component)Component.m_237115_((String)String.format("ability.%s.fail.failure", "jujutsu_kaisen")), false);
            }
        }
        return status == Ability.Status.SUCCESS;
    }

    public static Ability.Status trigger(Ability ability) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer owner = mc.f_91074_;
        if (owner == null) {
            return Ability.Status.FAILURE;
        }
        if (!owner.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return Ability.Status.FAILURE;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (ability.getActivationType((LivingEntity)owner) == Ability.ActivationType.INSTANT) {
            Ability.Status status = ability.isTriggerable((LivingEntity)owner);
            if (ClientAbilityHandler.isSuccess(ability, status)) {
                MinecraftForge.EVENT_BUS.post((Event)new AbilityTriggerEvent.Pre((LivingEntity)owner, ability));
                ability.run((LivingEntity)owner);
                ability.charge((LivingEntity)owner);
                MinecraftForge.EVENT_BUS.post((Event)new AbilityTriggerEvent.Post((LivingEntity)owner, ability));
            }
            return status;
        }
        if (ability.getActivationType((LivingEntity)owner) == Ability.ActivationType.TOGGLED) {
            Ability.Status status = ability.isTriggerable((LivingEntity)owner);
            if (ClientAbilityHandler.isSuccess(ability, status) | (status == Ability.Status.ENERGY && ability instanceof Ability.IAttack)) {
                MinecraftForge.EVENT_BUS.post((Event)new AbilityTriggerEvent.Pre((LivingEntity)owner, ability));
                cap.toggle(ability);
                MinecraftForge.EVENT_BUS.post((Event)new AbilityTriggerEvent.Post((LivingEntity)owner, ability));
            }
            return status;
        }
        if (ability.getActivationType((LivingEntity)owner) == Ability.ActivationType.CHANNELED) {
            Ability.Status status = ability.isTriggerable((LivingEntity)owner);
            if (ClientAbilityHandler.isSuccess(ability, status) || status == Ability.Status.ENERGY && ability instanceof Ability.IAttack) {
                MinecraftForge.EVENT_BUS.post((Event)new AbilityTriggerEvent.Pre((LivingEntity)owner, ability));
                cap.channel(ability);
                MinecraftForge.EVENT_BUS.post((Event)new AbilityTriggerEvent.Post((LivingEntity)owner, ability));
            }
            return status;
        }
        return Ability.Status.SUCCESS;
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientAbilityHandlerForgeEvents {
        @SubscribeEvent
        public static void onRenderLivingPre(RenderLivingEvent.Pre<?, ?> event) {
            LivingEntity entity = event.getEntity();
            ClientVisualHandler.ClientData data = ClientVisualHandler.get((Entity)entity);
            if (data == null) {
                return;
            }
            EntityModel entityModel = event.getRenderer().m_7200_();
            if (!(entityModel instanceof PlayerModel)) {
                return;
            }
            PlayerModel player = (PlayerModel)entityModel;
            for (Ability ability : data.toggled) {
                HumanoidModel.ArmPose pose;
                if (!(ability instanceof ITransformation)) continue;
                ITransformation transformation = (ITransformation)((Object)ability);
                if (transformation.isReplacement()) {
                    switch (transformation.getBodyPart()) {
                        case HEAD: {
                            player.f_102808_.f_104207_ = false;
                            player.f_102809_.f_104207_ = false;
                            break;
                        }
                        case BODY: {
                            player.m_8009_(false);
                            break;
                        }
                        case RIGHT_ARM: {
                            player.f_102811_.f_104207_ = false;
                            player.f_103375_.f_104207_ = false;
                            break;
                        }
                        case LEFT_ARM: {
                            player.f_102812_.f_104207_ = false;
                            player.f_103375_.f_104207_ = false;
                            break;
                        }
                        case LEGS: {
                            player.f_102813_.f_104207_ = false;
                            player.f_103377_.f_104207_ = false;
                            player.f_102814_.f_104207_ = false;
                            player.f_103376_.f_104207_ = false;
                        }
                    }
                }
                if ((pose = IClientItemExtensions.of((Item)transformation.getItem()).getArmPose(event.getEntity(), InteractionHand.MAIN_HAND, transformation.getItem().m_7968_())) == null) continue;
                if (transformation.getBodyPart() == ITransformation.Part.RIGHT_ARM) {
                    player.f_102816_ = pose;
                    continue;
                }
                if (transformation.getBodyPart() != ITransformation.Part.LEFT_ARM) continue;
                player.f_102815_ = pose;
            }
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            Entity entity;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            if (current != null) {
                boolean possiblyChanneling;
                boolean bl = possiblyChanneling = channeled != null;
                if (possiblyChanneling) {
                    boolean isHeld = current.m_90857_();
                    if (isHeld) {
                        if (!isChanneling && ClientAbilityHandler.trigger(channeled) == Ability.Status.SUCCESS) {
                            PacketHandler.sendToServer(new TriggerAbilityC2SPacket(JJKAbilities.getKey(channeled)));
                        }
                        isChanneling = true;
                    } else if (isChanneling) {
                        AbilityHandler.untrigger((LivingEntity)mc.f_91074_, channeled);
                        PacketHandler.sendToServer(new UntriggerAbilityC2SPacket(JJKAbilities.getKey(channeled)));
                        channeled = null;
                        current = null;
                        isChanneling = false;
                    }
                }
            }
            if ((entity = mc.f_91074_.m_20202_()) instanceof IRightClickInputListener) {
                IRightClickInputListener listener = (IRightClickInputListener)entity;
                if (!isRightDown && mc.f_91067_.m_91584_()) {
                    listener.setDown(true);
                    PacketHandler.sendToServer(new RightClickInputListenerC2SPacket(true));
                    isRightDown = true;
                } else if (isRightDown && !mc.f_91067_.m_91584_()) {
                    listener.setDown(false);
                    PacketHandler.sendToServer(new RightClickInputListenerC2SPacket(false));
                    isRightDown = false;
                }
            }
        }

        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            if (event.getKey() == 32 && (event.getAction() == 1 || event.getAction() == 0)) {
                boolean down = event.getAction() == 1;
                Entity entity = mc.f_91074_.m_20202_();
                if (entity instanceof IJumpInputListener) {
                    IJumpInputListener listener = (IJumpInputListener)entity;
                    listener.setJump(down);
                    PacketHandler.sendToServer(new JumpInputListenerC2SPacket(down));
                } else {
                    entity = mc.f_91074_.m_146895_();
                    if (entity instanceof IJumpInputListener) {
                        IJumpInputListener listener = (IJumpInputListener)entity;
                        listener.setJump(down);
                        PacketHandler.sendToServer(new JumpInputListenerC2SPacket(down));
                    }
                }
            }
            if (event.getAction() == 1) {
                Ability ability;
                Ability ability2;
                if (JJKKeys.ACTIVATE_ABILITY.m_90857_() && (ability2 = AbilityOverlay.getSelected()) != null) {
                    if (ability2.getActivationType((LivingEntity)mc.f_91074_) == Ability.ActivationType.CHANNELED) {
                        channeled = ability2;
                        current = JJKKeys.ACTIVATE_ABILITY;
                    } else if (ClientAbilityHandler.trigger(ability2) == Ability.Status.SUCCESS) {
                        PacketHandler.sendToServer(new TriggerAbilityC2SPacket(JJKAbilities.getKey(ability2)));
                    }
                }
                if (JJKKeys.ACTIVATE_J2TSU.m_90857_() && (ability = AbilityOverlay.getSelected2()) != null) {
                    if (ability.getActivationType((LivingEntity)mc.f_91074_) == Ability.ActivationType.CHANNELED) {
                        channeled = ability;
                        current = JJKKeys.ACTIVATE_J2TSU;
                    } else if (ClientAbilityHandler.trigger(ability) == Ability.Status.SUCCESS) {
                        PacketHandler.sendToServer(new TriggerAbilityC2SPacket(JJKAbilities.getKey(ability)));
                    }
                }
                if (JJKKeys.ACTIVATE_RCT_OR_HEAL.m_90857_()) {
                    RCT1 rct = EntityUtil.getRCTTier((LivingEntity)mc.f_91074_);
                    if (JJKAbilities.getType((LivingEntity)mc.f_91074_) == JujutsuType.CURSE) {
                        channeled = (Ability)JJKAbilities.HEAL.get();
                        current = JJKKeys.ACTIVATE_RCT_OR_HEAL;
                    } else if (rct != null) {
                        channeled = rct;
                        current = JJKKeys.ACTIVATE_RCT_OR_HEAL;
                    }
                }
                if (JJKKeys.ACTIVATE_CURSED_ENERGY_SHIELD.m_90857_()) {
                    channeled = (Ability)JJKAbilities.CURSED_ENERGY_SHIELD.get();
                    current = JJKKeys.ACTIVATE_CURSED_ENERGY_SHIELD;
                }
                if (JJKKeys.DASH.m_90857_() && ClientAbilityHandler.trigger((Ability)JJKAbilities.DASH.get()) == Ability.Status.SUCCESS) {
                    PacketHandler.sendToServer(new TriggerAbilityC2SPacket(JJKAbilities.getKey((Ability)JJKAbilities.DASH.get())));
                }
                if (JJKKeys.QUICKDASH.m_90857_() && ClientAbilityHandler.trigger((Ability)JJKAbilities.QUICKDASH.get()) == Ability.Status.SUCCESS) {
                    PacketHandler.sendToServer(new TriggerAbilityC2SPacket(JJKAbilities.getKey((Ability)JJKAbilities.QUICKDASH.get())));
                }
            } else if (event.getAction() == 0) {
                if (current != null) {
                    boolean possiblyChanneling;
                    boolean bl = possiblyChanneling = channeled != null;
                    if (possiblyChanneling && event.getKey() == current.getKey().m_84873_()) {
                        AbilityHandler.untrigger((LivingEntity)mc.f_91074_, channeled);
                        PacketHandler.sendToServer(new UntriggerAbilityC2SPacket(JJKAbilities.getKey(channeled)));
                        channeled = null;
                        current = null;
                        isChanneling = false;
                    }
                }
                if (event.getKey() == JJKKeys.SHOW_ABILITY_MENU.getKey().m_84873_() && mc.f_91080_ instanceof AbilityScreen || event.getKey() == JJKKeys.SHOW_DOMAIN_MENU.getKey().m_84873_() && mc.f_91080_ instanceof DomainScreen || event.getKey() == JJKKeys.ACTIVATE_ABILITY.getKey().m_84873_() && mc.f_91080_ instanceof ShadowInventoryScreen) {
                    mc.f_91080_.m_7379_();
                }
            }
        }
    }
}

