/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.overlay;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.gui.MeleeMenuType;
import radon.jujutsu_kaisen.client.gui.screen.JutwotsuScreen;
import radon.jujutsu_kaisen.client.gui.screen.MeleeScreen;
import radon.jujutsu_kaisen.config.ConfigHolder;

public class AbilityOverlay {
    private static int selected;
    private static List<Ability> abilities;
    public static IGuiOverlay OVERLAY;

    public static boolean scroll(int direction) {
        int i = -((int)Math.signum(direction));
        int count = abilities.size();
        if (count == 0) {
            return false;
        }
        selected += i;
        while (selected < 0) {
            selected += count;
        }
        while (selected >= count) {
            selected -= count;
        }
        return true;
    }

    @Nullable
    public static Ability getSelected() {
        if (ConfigHolder.CLIENT.meleeMenuType.get() == MeleeMenuType.SCROLL) {
            if (abilities.isEmpty()) {
                return null;
            }
            int index = AbilityOverlay.getIndex();
            if (abilities.size() > index) {
                return abilities.get(index);
            }
        } else if (ConfigHolder.CLIENT.meleeMenuType.get() == MeleeMenuType.TOGGLE) {
            return MeleeScreen.getSelected();
        }
        return null;
    }

    @Nullable
    public static Ability getSelected2() {
        return JutwotsuScreen.getSelected();
    }

    private static int getIndex() {
        int index;
        int count = abilities.size();
        for (index = selected; index < 0; index += count) {
        }
        while (index >= count) {
            index -= count;
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    private static void render(ForgeGui gui, GuiGraphics graphics, int width, int height, Ability ability) {
        Ability.IDurationable durationable;
        int duration;
        int cooldown;
        Minecraft mc = gui.getMinecraft();
        if (mc.f_91074_ == null || ability == null) {
            return;
        }
        if (!mc.f_91074_.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return;
        }
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        MutableComponent nameText = Component.m_237110_((String)String.format("gui.%s.ability_overlay.name", "jujutsu_kaisen"), (Object[])new Object[]{ability.getName()});
        lines.add(nameText);
        float cost = ability.getRealCost((LivingEntity)mc.f_91074_);
        if (cost > 0.0f) {
            lines.add(Component.m_237110_((String)String.format("gui.%s.ability_overlay.cost", "jujutsu_kaisen"), (Object[])new Object[]{Float.valueOf(cost)}));
        }
        if ((cooldown = ability.getRealCooldown((LivingEntity)mc.f_91074_)) > 0) {
            lines.add(Component.m_237110_((String)String.format("gui.%s.ability_overlay.cooldown", "jujutsu_kaisen"), (Object[])new Object[]{Math.round((float)cooldown / 20.0f)}));
        }
        if (ability instanceof Ability.IDurationable && (duration = (durationable = (Ability.IDurationable)((Object)ability)).getRealDuration((LivingEntity)mc.f_91074_)) > 0) {
            MutableComponent mutableComponent = Component.m_237110_((String)String.format("gui.%s.ability_overlay.duration", "jujutsu_kaisen"), (Object[])new Object[]{Float.valueOf((float)duration / 20.0f)});
            lines.add(mutableComponent);
        }
        int offset = 0;
        for (Component component : lines) {
            if (mc.f_91062_.m_92852_((FormattedText)component) <= offset) continue;
            offset = mc.f_91062_.m_92852_((FormattedText)component);
        }
        int x = width - 20 - offset;
        int n = lines.size();
        Objects.requireNonNull(mc.f_91062_);
        int n2 = height - 20 - (n * 9 + 2);
        for (Component component : lines) {
            void var12_19;
            graphics.m_280430_(gui.m_93082_(), component, x, (int)var12_19, 0xFFFFFF);
            Objects.requireNonNull(mc.f_91062_);
            var12_19 += 9;
        }
    }

    static {
        abilities = new ArrayList<Ability>();
        OVERLAY = (gui, graphics, partialTicks, width, height) -> {
            Ability selected;
            Minecraft mc = gui.getMinecraft();
            if (mc.f_91074_ == null) {
                return;
            }
            if (ConfigHolder.CLIENT.meleeMenuType.get() == MeleeMenuType.SCROLL) {
                abilities = JJKAbilities.getAbilities((LivingEntity)mc.f_91074_);
                abilities.removeIf(ability -> ability.getMenuType() != MenuType.MELEE);
                if (!abilities.isEmpty()) {
                    int index = AbilityOverlay.getIndex();
                    Ability ability2 = abilities.get(index);
                    AbilityOverlay.render(gui, graphics, width, height, ability2);
                }
            } else if (ConfigHolder.CLIENT.meleeMenuType.get() == MeleeMenuType.TOGGLE) {
                Ability selected2 = MeleeScreen.getSelected();
                if (selected2 == null) {
                    return;
                }
                if (!selected2.isValid((LivingEntity)mc.f_91074_) || !JJKAbilities.getAbilities((LivingEntity)mc.f_91074_).contains(selected2)) {
                    selected2 = null;
                }
                AbilityOverlay.render(gui, graphics, width, height, selected2);
            }
            if ((selected = JutwotsuScreen.getSelected()) == null) {
                return;
            }
            if (!selected.isValid((LivingEntity)mc.f_91074_) || !JJKAbilities.getAbilities((LivingEntity)mc.f_91074_).contains(selected)) {
                selected = null;
            }
            AbilityOverlay.render(gui, graphics, width, height - 30, selected);
        };
    }
}

