/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.screen.tab;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Items;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.client.gui.screen.JujutsuScreen;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTab;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTabType;
import radon.jujutsu_kaisen.util.SorcererUtil;

public class StatsTab
extends JJKTab {
    private static final Component TITLE = Component.m_237115_((String)String.format("gui.%s.stats", "jujutsu_kaisen"));
    private static final ResourceLocation BACKGROUND = new ResourceLocation("textures/gui/advancements/backgrounds/stone.png");
    private static final int[] TEST_SPLIT_OFFSETS = new int[]{0, 10, -10, 25, -25};

    public StatsTab(Minecraft minecraft, JujutsuScreen screen, JJKTabType type, int index, int page) {
        super(minecraft, screen, type, index, page, Items.f_41997_.m_7968_(), TITLE, BACKGROUND, true);
    }

    private static void drawHead(GuiGraphics pGuiGraphics, ResourceLocation pAtlasLocation, int xOffset, int yOffset, int pSize) {
        int i = 8;
        int j = 8;
        pGuiGraphics.m_280411_(pAtlasLocation, xOffset, yOffset, i * pSize, j * pSize, 8.0f, 8.0f, i, j, 64, 64);
        StatsTab.drawHat(pGuiGraphics, pAtlasLocation, xOffset, yOffset, pSize);
    }

    private static void drawHat(GuiGraphics pGuiGraphics, ResourceLocation pAtlasLocation, int xOffset, int yOffset, int pSize) {
        int i = 8;
        int j = 8;
        RenderSystem.enableBlend();
        pGuiGraphics.m_280411_(pAtlasLocation, xOffset, yOffset, i * pSize, j * pSize, 40.0f, 8.0f, i, j, 64, 64);
        RenderSystem.disableBlend();
    }

    private static void drawUpperBody(GuiGraphics pGuiGraphics, ResourceLocation pAtlasLocation, int xOffset, int yOffset, int pSize) {
        int i = 8;
        int j = 6;
        pGuiGraphics.m_280411_(pAtlasLocation, xOffset, yOffset, i * pSize, j * pSize, 20.0f, 20.0f, i, j, 64, 64);
    }

    private static void drawRightArm(GuiGraphics pGuiGraphics, ResourceLocation pAtlasLocation, int xOffset, int yOffset, int pSize) {
        int i = 2;
        int j = 6;
        pGuiGraphics.m_280411_(pAtlasLocation, xOffset, yOffset, i * pSize, j * pSize, 44.0f, 20.0f, i, j, 64, 64);
    }

    private static void drawLeftArm(GuiGraphics pGuiGraphics, ResourceLocation pAtlasLocation, int xOffset, int yOffset, int pSize) {
        int i = 2;
        int j = 6;
        pGuiGraphics.m_280411_(pAtlasLocation, xOffset, yOffset, i * pSize, j * pSize, 36.0f, 52.0f, i, j, 64, 64);
    }

    private static float getMaxWidth(StringSplitter pManager, List<FormattedText> pText) {
        return (float)pText.stream().mapToDouble(arg_0 -> ((StringSplitter)pManager).m_92384_(arg_0)).max().orElse(0.0);
    }

    private List<FormattedText> findOptimalLines(Component pComponent, int pMaxWidth) {
        StringSplitter stringsplitter = this.minecraft.f_91062_.m_92865_();
        List list = null;
        float f = Float.MAX_VALUE;
        for (int i : TEST_SPLIT_OFFSETS) {
            List list1 = stringsplitter.m_92414_((FormattedText)pComponent, pMaxWidth - i, Style.f_131099_);
            float f1 = Math.abs(StatsTab.getMaxWidth(stringsplitter, list1) - (float)pMaxWidth);
            if (f1 <= 10.0f) {
                return list1;
            }
            if (!(f1 < f)) continue;
            f = f1;
            list = list1;
        }
        return list;
    }

    @Override
    public void drawContents(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.drawContents(pGuiGraphics, pX, pY);
        int i = (this.screen.f_96543_ - 252) / 2;
        int j = (this.screen.f_96544_ - 140) / 2;
        int xOffset = i + 18;
        int yOffset = j + 27;
        StatsTab.drawHead(pGuiGraphics, this.minecraft.f_91074_.m_108560_(), xOffset + 12, yOffset, 6);
        StatsTab.drawUpperBody(pGuiGraphics, this.minecraft.f_91074_.m_108560_(), xOffset + 12, yOffset + 47, 6);
        StatsTab.drawRightArm(pGuiGraphics, this.minecraft.f_91074_.m_108560_(), xOffset, yOffset + 47, 6);
        StatsTab.drawLeftArm(pGuiGraphics, this.minecraft.f_91074_.m_108560_(), xOffset + 60, yOffset + 47, 6);
        ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        SorcererGrade grade = SorcererUtil.getGrade(cap.getExperience());
        SorcererGrade next = SorcererGrade.values()[Math.min(SorcererGrade.values().length - 1, grade.ordinal() + 1)];
        MutableComponent component = Component.m_237119_();
        component.m_7220_((Component)Component.m_237110_((String)String.format("gui.%s.stats.grade", "jujutsu_kaisen"), (Object[])new Object[]{grade.getName()}));
        component.m_130946_("\n");
        component.m_7220_((Component)Component.m_237110_((String)String.format("gui.%s.stats.experience", "jujutsu_kaisen"), (Object[])new Object[]{Float.valueOf(cap.getExperience()), Float.valueOf(next.getRequiredExperience())}));
        component.m_130946_("\n");
        CursedTechnique technique = cap.getTechnique();
        if (technique != null && technique != CursedTechnique.TECHNIQUELESS) {
            component.m_7220_((Component)Component.m_237110_((String)String.format("gui.%s.stats.cursed_technique", "jujutsu_kaisen"), (Object[])new Object[]{technique.getName()}));
            component.m_130946_("\n");
        } else if (technique == null || technique == CursedTechnique.TECHNIQUELESS) {
            component.m_7220_((Component)Component.m_237110_((String)String.format("gui.%s.stats.cursed_technique", "jujutsu_kaisen"), (Object[])new Object[]{String.format("gui.%s.stats.cursed_technique.none", "jujutsu_kaisen")}));
            component.m_130946_("\n");
        }
        if (!cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
            component.m_7220_((Component)Component.m_237110_((String)String.format("gui.%s.stats.cursed_energy_nature", "jujutsu_kaisen"), (Object[])new Object[]{cap.getNature().getName()}));
            component.m_130946_("\n");
        }
        component.m_7220_((Component)Component.m_237110_((String)String.format("gui.%s.stats.traits", "jujutsu_kaisen"), (Object[])new Object[]{cap.getTraits().stream().map(Trait::getName).map(Component::getString).collect(Collectors.joining(", "))}));
        component.m_130946_("\n");
        List lines = Language.m_128107_().m_128112_(this.findOptimalLines((Component)ComponentUtils.m_130750_((MutableComponent)component, (Style)Style.f_131099_), 130));
        int offset = 0;
        for (FormattedCharSequence line : lines) {
            pGuiGraphics.m_280648_(this.minecraft.f_91062_, line, xOffset + 80, yOffset + offset, 0xFFFFFF);
            Objects.requireNonNull(this.minecraft.f_91062_);
            offset += 9;
        }
    }

    @Override
    public void addWidgets() {
    }
}

