/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.render.entity.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import radon.jujutsu_kaisen.client.JJKRenderTypes;
import radon.jujutsu_kaisen.entity.HollowWickerBasketEntity;

public class HollowWickerBasketRenderer
extends EntityRenderer<HollowWickerBasketEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("jujutsu_kaisen", "textures/entity/hollow_wicker_basket.png");

    public HollowWickerBasketRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(HollowWickerBasketEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)entity.m_20206_() * 0.9, 0.0);
        float radius = 1.25f;
        int stacks = 64;
        int slices = 64;
        float tileU = 4.0f;
        float tileV = 4.0f;
        VertexConsumer consumer = buffer.m_6299_(JJKRenderTypes.hollow_wicker_basket(TEXTURE));
        float[][][] positions = new float[65][65][3];
        float[][][] uvs = new float[65][65][2];
        for (int i = 0; i <= 64; ++i) {
            float phi = (float)Math.PI * (float)i / 64.0f;
            float v = (float)i / 64.0f * 4.0f;
            for (int j = 0; j <= 64; ++j) {
                float theta = (float)(Math.PI * 2 * (double)j / 64.0);
                float u = (float)j / 64.0f * 4.0f;
                float x = (float)((double)radius * Math.sin(phi) * Math.cos(theta));
                float y = (float)((double)radius * Math.cos(phi));
                float z = (float)((double)radius * Math.sin(phi) * Math.sin(theta));
                positions[i][j][0] = x;
                positions[i][j][1] = y;
                positions[i][j][2] = z;
                uvs[i][j][0] = u;
                uvs[i][j][1] = v;
            }
        }
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f posMat = pose.m_252922_();
        Matrix3f normalMat = pose.m_252943_();
        float alpha = 0.2f;
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                float[] v1 = positions[i][j];
                float[] v2 = positions[i][j + 1];
                float[] v3 = positions[i + 1][j + 1];
                float[] v4 = positions[i + 1][j];
                float[] uv1 = uvs[i][j];
                float[] uv2 = uvs[i][j + 1];
                float[] uv3 = uvs[i + 1][j + 1];
                float[] uv4 = uvs[i + 1][j];
                HollowWickerBasketRenderer.addQuadDualSided(consumer, posMat, normalMat, v1, uv1, v2, uv2, v3, uv3, v4, uv4, 0.2f, packedLight, radius);
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    private static void addTriangleDualSided(VertexConsumer consumer, Matrix4f mat, Matrix3f normalMat, float[] aPos, float[] aUV, float[] bPos, float[] bUV, float[] cPos, float[] cUV, float alpha, int light, float radius) {
        float[] an = HollowWickerBasketRenderer.normalize(aPos, radius);
        float[] bn = HollowWickerBasketRenderer.normalize(bPos, radius);
        float[] cn = HollowWickerBasketRenderer.normalize(cPos, radius);
        HollowWickerBasketRenderer.putVertex(consumer, mat, normalMat, aPos, aUV, an, alpha, light);
        HollowWickerBasketRenderer.putVertex(consumer, mat, normalMat, bPos, bUV, bn, alpha, light);
        HollowWickerBasketRenderer.putVertex(consumer, mat, normalMat, cPos, cUV, cn, alpha, light);
        HollowWickerBasketRenderer.putVertex(consumer, mat, normalMat, cPos, cUV, HollowWickerBasketRenderer.negate(cn), alpha, light);
        HollowWickerBasketRenderer.putVertex(consumer, mat, normalMat, bPos, bUV, HollowWickerBasketRenderer.negate(bn), alpha, light);
        HollowWickerBasketRenderer.putVertex(consumer, mat, normalMat, aPos, aUV, HollowWickerBasketRenderer.negate(an), alpha, light);
    }

    private static void putVertex(VertexConsumer consumer, Matrix4f mat, Matrix3f normalMat, float[] pos, float[] uv, float[] normal, float alpha, int light) {
        consumer.m_252986_(mat, pos[0], pos[1], pos[2]).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(uv[0], uv[1]).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMat, normal[0], normal[1], normal[2]).m_5752_();
    }

    private static void addQuadDualSided(VertexConsumer consumer, Matrix4f mat, Matrix3f normalMat, float[] v1, float[] uv1, float[] v2, float[] uv2, float[] v3, float[] uv3, float[] v4, float[] uv4, float alpha, int light, float radius) {
        float[] n1 = HollowWickerBasketRenderer.normalize(v1, radius);
        float[] n2 = HollowWickerBasketRenderer.normalize(v2, radius);
        float[] n3 = HollowWickerBasketRenderer.normalize(v3, radius);
        float[] n4 = HollowWickerBasketRenderer.normalize(v4, radius);
        HollowWickerBasketRenderer.putVertex(consumer, mat, normalMat, v1, uv1, n1, alpha, light);
        HollowWickerBasketRenderer.putVertex(consumer, mat, normalMat, v2, uv2, n2, alpha, light);
        HollowWickerBasketRenderer.putVertex(consumer, mat, normalMat, v3, uv3, n3, alpha, light);
        HollowWickerBasketRenderer.putVertex(consumer, mat, normalMat, v4, uv4, n4, alpha, light);
        float shrink = 0.999f;
        float[] v1i = new float[]{v1[0] * 0.999f, v1[1] * 0.999f, v1[2] * 0.999f};
        float[] v2i = new float[]{v2[0] * 0.999f, v2[1] * 0.999f, v2[2] * 0.999f};
        float[] v3i = new float[]{v3[0] * 0.999f, v3[1] * 0.999f, v3[2] * 0.999f};
        float[] v4i = new float[]{v4[0] * 0.999f, v4[1] * 0.999f, v4[2] * 0.999f};
        HollowWickerBasketRenderer.putVertex(consumer, mat, normalMat, v4i, uv4, HollowWickerBasketRenderer.negate(n4), alpha, light);
        HollowWickerBasketRenderer.putVertex(consumer, mat, normalMat, v3i, uv3, HollowWickerBasketRenderer.negate(n3), alpha, light);
        HollowWickerBasketRenderer.putVertex(consumer, mat, normalMat, v2i, uv2, HollowWickerBasketRenderer.negate(n2), alpha, light);
        HollowWickerBasketRenderer.putVertex(consumer, mat, normalMat, v1i, uv1, HollowWickerBasketRenderer.negate(n1), alpha, light);
    }

    private static float[] normalize(float[] pos, float radius) {
        float x = pos[0];
        float y = pos[1];
        float z = pos[2];
        float len = (float)Math.sqrt(x * x + y * y + z * z);
        if (len == 0.0f) {
            return new float[]{0.0f, 1.0f, 0.0f};
        }
        return new float[]{x / len, y / len, z / len};
    }

    private static float[] negate(float[] v) {
        return new float[]{-v[0], -v[1], -v[2]};
    }

    public ResourceLocation getTextureLocation(HollowWickerBasketEntity entity) {
        return TEXTURE;
    }
}

