/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.slice;

import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import radon.jujutsu_kaisen.client.slice.Collider;
import radon.jujutsu_kaisen.client.slice.RigidBody;

public class ConvexMeshCollider
extends Collider {
    public RigidBody.Triangle[] triangles;
    public float[] vertices;
    public int[] indices;
    public AABB localBox;

    private ConvexMeshCollider() {
    }

    public ConvexMeshCollider(int[] indices, float[] vertices, float density) {
        this.fromData(indices, vertices, density);
    }

    private static Vec3 setVal(Vec3 vec, int idx, double val) {
        return switch (idx) {
            case 0 -> new Vec3(val, vec.f_82480_, vec.f_82481_);
            case 1 -> new Vec3(vec.f_82479_, val, vec.f_82481_);
            case 2 -> new Vec3(vec.f_82479_, vec.f_82480_, val);
            default -> throw new RuntimeException("Out of range!");
        };
    }

    private static double val(Vec3 vec, int idx) {
        return switch (idx) {
            case 0 -> vec.f_82479_;
            case 1 -> vec.f_82480_;
            case 2 -> vec.f_82481_;
            default -> throw new RuntimeException("Out of range!");
        };
    }

    public void fromData(int[] indices, float[] vertices, float density) {
        this.fromData(indices, vertices);
        this.localCentroid = this.computeCenterOfMass();
        this.mass = this.computeVolume() * density;
        this.localInertiaTensor = this.computeInertia(this.localCentroid, this.mass);
    }

    public void fromData(int[] indices, float[] vertices) {
        this.indices = indices;
        this.vertices = vertices;
        this.triangles = new RigidBody.Triangle[indices.length / 3];
        for (int i = 0; i < indices.length; i += 3) {
            Vec3 p1 = new Vec3((double)vertices[indices[i] * 3], (double)vertices[indices[i] * 3 + 1], (double)vertices[indices[i] * 3 + 2]);
            Vec3 p2 = new Vec3((double)vertices[indices[i + 1] * 3], (double)vertices[indices[i + 1] * 3 + 1], (double)vertices[indices[i + 1] * 3 + 2]);
            Vec3 p3 = new Vec3((double)vertices[indices[i + 2] * 3], (double)vertices[indices[i + 2] * 3 + 1], (double)vertices[indices[i + 2] * 3 + 2]);
            this.triangles[i / 3] = new RigidBody.Triangle(p1, p2, p3);
        }
        double maxX = this.support((Vec3)RigidBody.cardinals[0]).f_82479_;
        double maxY = this.support((Vec3)RigidBody.cardinals[1]).f_82480_;
        double maxZ = this.support((Vec3)RigidBody.cardinals[2]).f_82481_;
        double minX = this.support((Vec3)RigidBody.cardinals[3]).f_82479_;
        double minY = this.support((Vec3)RigidBody.cardinals[4]).f_82480_;
        double minZ = this.support((Vec3)RigidBody.cardinals[5]).f_82481_;
        this.localBox = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private float computeVolume() {
        float volume = 0.0f;
        for (RigidBody.Triangle triangle : this.triangles) {
            Matrix3f mat = new Matrix3f((float)triangle.p1.pos.f_82479_, (float)triangle.p1.pos.f_82480_, (float)triangle.p1.pos.f_82481_, (float)triangle.p2.pos.f_82479_, (float)triangle.p2.pos.f_82480_, (float)triangle.p2.pos.f_82481_, (float)triangle.p3.pos.f_82479_, (float)triangle.p3.pos.f_82480_, (float)triangle.p3.pos.f_82481_);
            float vol = mat.m00 * (mat.m11 * mat.m22 - mat.m12 * mat.m21) + mat.m01 * (mat.m12 * mat.m20 - mat.m10 * mat.m22) + mat.m02 * (mat.m10 * mat.m21 - mat.m11 * mat.m20);
            volume += vol;
        }
        return volume / 6.0f;
    }

    private Vec3 computeCenterOfMass() {
        Vec3 center = Vec3.f_82478_;
        float volume = 0.0f;
        for (RigidBody.Triangle triangle : this.triangles) {
            Matrix3f mat = new Matrix3f((float)triangle.p1.pos.f_82479_, (float)triangle.p1.pos.f_82480_, (float)triangle.p1.pos.f_82481_, (float)triangle.p2.pos.f_82479_, (float)triangle.p2.pos.f_82480_, (float)triangle.p2.pos.f_82481_, (float)triangle.p3.pos.f_82479_, (float)triangle.p3.pos.f_82480_, (float)triangle.p3.pos.f_82481_);
            float vol = mat.m00 * (mat.m11 * mat.m22 - mat.m12 * mat.m21) + mat.m01 * (mat.m12 * mat.m20 - mat.m10 * mat.m22) + mat.m02 * (mat.m10 * mat.m21 - mat.m11 * mat.m20);
            center = center.m_82520_((double)(vol * (mat.m00 + mat.m10 + mat.m20)), (double)(vol * (mat.m01 + mat.m11 + mat.m21)), (double)(vol * (mat.m02 + mat.m12 + mat.m22)));
            volume += vol;
        }
        if (volume == 0.0f) {
            return Vec3.f_82478_;
        }
        return new Vec3(center.f_82479_ / (double)(volume * 4.0f), center.f_82480_ / (double)(volume * 4.0f), center.f_82481_ / (double)(volume * 4.0f));
    }

    private Matrix3f computeInertia(Vec3 com, float mass) {
        float volume = 0.0f;
        Vec3 diag = Vec3.f_82478_;
        Vec3 offd = Vec3.f_82478_;
        for (RigidBody.Triangle t : this.triangles) {
            Matrix3f mat = new Matrix3f((float)(t.p1.pos.f_82479_ - com.f_82479_), (float)(t.p1.pos.f_82480_ - com.f_82480_), (float)(t.p1.pos.f_82481_ - com.f_82481_), (float)(t.p2.pos.f_82479_ - com.f_82479_), (float)(t.p2.pos.f_82480_ - com.f_82480_), (float)(t.p2.pos.f_82481_ - com.f_82481_), (float)(t.p3.pos.f_82479_ - com.f_82479_), (float)(t.p3.pos.f_82480_ - com.f_82480_), (float)(t.p3.pos.f_82481_ - com.f_82481_));
            float vol = mat.m00 * (mat.m11 * mat.m22 - mat.m12 * mat.m21) + mat.m01 * (mat.m12 * mat.m20 - mat.m10 * mat.m22) + mat.m02 * (mat.m10 * mat.m21 - mat.m11 * mat.m20);
            volume += vol;
            for (int j = 0; j < 3; ++j) {
                int j1 = (j + 1) % 3;
                int j2 = (j + 2) % 3;
                diag = ConvexMeshCollider.setVal(diag, j, ConvexMeshCollider.val(diag, j) + (double)((mat.get(0, j) * mat.get(1, j) + mat.get(1, j) * mat.get(2, j) + mat.get(2, j) * mat.get(0, j) + mat.get(0, j) * mat.get(0, j) + mat.get(1, j) * mat.get(1, j) + mat.get(2, j) * mat.get(2, j)) * vol));
                offd = ConvexMeshCollider.setVal(offd, j, ConvexMeshCollider.val(offd, j) + (double)((mat.get(0, j1) * mat.get(1, j2) + mat.get(1, j1) * mat.get(2, j2) + mat.get(2, j1) * mat.get(0, j2) + mat.get(0, j1) * mat.get(2, j2) + mat.get(1, j1) * mat.get(0, j2) + mat.get(2, j1) * mat.get(1, j2) + mat.get(0, j1) * mat.get(0, j2) + mat.get(1, j1) * mat.get(1, j2) + mat.get(2, j1) * mat.get(2, j2)) * vol));
            }
        }
        if (volume > 0.0f) {
            float volume2 = volume * 10.0f;
            diag = new Vec3(diag.f_82479_ / (double)volume2, diag.f_82480_ / (double)volume2, diag.f_82481_ / (double)volume2);
            volume2 = volume * 20.0f;
            offd = new Vec3(offd.f_82479_ / (double)volume2, offd.f_82480_ / (double)volume2, offd.f_82481_ / (double)volume2);
        }
        diag = diag.m_82490_((double)mass);
        offd = offd.m_82490_((double)mass);
        return new Matrix3f((float)(diag.f_82480_ + diag.f_82481_), (float)(-offd.f_82481_), (float)(-offd.f_82480_), (float)(-offd.f_82481_), (float)(diag.f_82479_ + diag.f_82481_), (float)(-offd.f_82479_), (float)(-offd.f_82480_), (float)(-offd.f_82479_), (float)(diag.f_82479_ + diag.f_82480_));
    }

    @Override
    public Vec3 support(Vec3 dir) {
        double dot = -3.4028234663852886E38;
        int index = 0;
        for (int i = 0; i < this.vertices.length; i += 3) {
            double newDot = dir.f_82479_ * (double)this.vertices[i] + dir.f_82480_ * (double)this.vertices[i + 1] + dir.f_82481_ * (double)this.vertices[i + 2];
            if (!(newDot > dot)) continue;
            dot = newDot;
            index = i;
        }
        return new Vec3((double)this.vertices[index], (double)this.vertices[index + 1], (double)this.vertices[index + 2]);
    }

    @Override
    public Collider copy() {
        ConvexMeshCollider collider = new ConvexMeshCollider();
        collider.vertices = this.vertices;
        collider.indices = this.indices;
        collider.triangles = this.triangles;
        collider.localBox = this.localBox;
        collider.localCentroid = this.localCentroid;
        collider.localInertiaTensor = this.localInertiaTensor;
        collider.mass = this.mass;
        return collider;
    }
}

