/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.visual;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.client.visual.JJKOverlays;
import radon.jujutsu_kaisen.client.visual.JJKVisuals;
import radon.jujutsu_kaisen.client.visual.base.IOverlay;
import radon.jujutsu_kaisen.client.visual.base.IVisual;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.c2s.RequestVisualDataC2SPacket;

@Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientVisualHandler {
    private static final Map<UUID, ClientData> synced = new HashMap<UUID, ClientData>();

    public static void receive(UUID identifier, CompoundTag nbt) {
        if (!synced.containsKey(identifier)) {
            synced.put(identifier, new ClientData(nbt));
            return;
        }
        synced.get(identifier).deserializeNBT(nbt);
    }

    @Nullable
    public static ClientData get(UUID identifier) {
        return synced.get(identifier);
    }

    @Nullable
    public static ClientData get(Entity entity) {
        if (!entity.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return null;
        }
        Minecraft mc = Minecraft.m_91087_();
        assert (mc.f_91073_ != null && mc.f_91074_ != null);
        if (synced.containsKey(entity.m_20148_())) {
            return synced.get(entity.m_20148_());
        }
        if (entity == mc.f_91074_ && mc.f_91074_.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            ISorcererData cap = (ISorcererData)mc.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            HashSet<CursedTechnique> techniques = new HashSet<CursedTechnique>();
            if (cap.getTechnique() != null) {
                techniques.add(cap.getTechnique());
            }
            if (cap.getCurrentCopied() != null) {
                techniques.add(cap.getCurrentCopied());
            }
            if (cap.getCurrentAbsorbed() != null) {
                techniques.add(cap.getCurrentAbsorbed());
            }
            if (cap.getCurrentStolen() != null) {
                techniques.add(cap.getCurrentStolen());
            }
            if (cap.getAdditional() != null) {
                techniques.add(cap.getAdditional());
            }
            return new ClientData(cap.getToggled(), cap.getChanneled(), cap.getTraits(), techniques, cap.getTechnique(), cap.getType(), cap.getExperience(), cap.getCursedEnergyColor());
        }
        return null;
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        ClientData data = ClientVisualHandler.get((Entity)entity);
        if (data == null) {
            return;
        }
        for (IVisual visual : JJKVisuals.VISUALS) {
            if (!visual.isValid(entity, data)) continue;
            visual.tick(entity, data);
        }
    }

    public static <T extends LivingEntity> void renderOverlays(T entity, ResourceLocation texture, EntityModel<T> model, PoseStack poseStack, MultiBufferSource buffer, float partialTicks, int packedLight) {
        ClientData data = ClientVisualHandler.get(entity);
        if (data == null) {
            return;
        }
        for (IOverlay overlay : JJKOverlays.OVERLAYS) {
            if (!overlay.isValid(entity, data)) continue;
            overlay.render(entity, data, texture, model, poseStack, buffer, partialTicks, packedLight);
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        synced.remove(event.getEntity().m_20148_());
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() == null) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            PacketHandler.sendToServer(new RequestVisualDataC2SPacket(entity.m_20148_()));
        }
    }

    public static class ClientData {
        public Set<Ability> toggled;
        @Nullable
        public Ability channeled;
        public Set<Trait> traits;
        public Set<CursedTechnique> techniques;
        @Nullable
        public CursedTechnique technique;
        public JujutsuType type;
        public float experience;
        public int cursedEnergyColor;
        public int mouth;

        public ClientData(Set<Ability> toggled, @Nullable Ability channeled, Set<Trait> traits, Set<CursedTechnique> techniques, @Nullable CursedTechnique technique, JujutsuType type, float experience, int cursedEnergyColor) {
            this.toggled = toggled;
            this.channeled = channeled;
            this.traits = traits;
            this.techniques = techniques;
            this.technique = technique;
            this.type = type;
            this.experience = experience;
            this.cursedEnergyColor = cursedEnergyColor;
        }

        public ClientData(CompoundTag nbt) {
            this.deserializeNBT(nbt);
        }

        public void deserializeNBT(CompoundTag nbt) {
            IntTag tag;
            this.toggled = new HashSet<Ability>();
            this.channeled = nbt.m_128441_("channeled") ? JJKAbilities.getValue(new ResourceLocation(nbt.m_128461_("channeled"))) : null;
            this.traits = new HashSet<Trait>();
            this.techniques = new HashSet<CursedTechnique>();
            this.technique = nbt.m_128441_("technique") ? CursedTechnique.values()[nbt.m_128451_("technique")] : null;
            for (Tag key : nbt.m_128437_("toggled", 8)) {
                this.toggled.add(JJKAbilities.getValue(new ResourceLocation(key.m_7916_())));
            }
            for (Tag key : nbt.m_128437_("traits", 3)) {
                if (!(key instanceof IntTag)) continue;
                tag = (IntTag)key;
                this.traits.add(Trait.values()[tag.m_7047_()]);
            }
            for (Tag key : nbt.m_128437_("techniques", 3)) {
                if (!(key instanceof IntTag)) continue;
                tag = (IntTag)key;
                this.techniques.add(CursedTechnique.values()[tag.m_7047_()]);
            }
            this.type = JujutsuType.values()[nbt.m_128451_("type")];
            this.experience = nbt.m_128457_("experience");
            this.cursedEnergyColor = nbt.m_128451_("cursed_energy_color");
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            ListTag toggledTag = new ListTag();
            for (Ability ability : this.toggled) {
                toggledTag.add((Object)StringTag.m_129297_((String)JJKAbilities.getKey(ability).toString()));
            }
            nbt.m_128365_("toggled", (Tag)toggledTag);
            if (this.channeled != null) {
                nbt.m_128359_("channeled", JJKAbilities.getKey(this.channeled).toString());
            }
            ListTag traitsTag = new ListTag();
            for (Trait trait : this.traits) {
                traitsTag.add((Object)IntTag.m_128679_((int)trait.ordinal()));
            }
            nbt.m_128365_("traits", (Tag)traitsTag);
            ListTag listTag = new ListTag();
            for (CursedTechnique technique : this.techniques) {
                listTag.add((Object)IntTag.m_128679_((int)technique.ordinal()));
            }
            nbt.m_128365_("techniques", (Tag)listTag);
            if (this.technique != null) {
                nbt.m_128405_("technique", this.technique.ordinal());
            }
            nbt.m_128405_("type", this.type.ordinal());
            nbt.m_128350_("experience", this.experience);
            nbt.m_128405_("cursed_energy_color", this.cursedEnergyColor);
            return nbt;
        }
    }
}

