/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;

public class JujutsuLightningEntity
extends LightningBolt {
    private int life;
    public long seed;
    private int flashes;
    private float damage;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;

    public JujutsuLightningEntity(EntityType<? extends LightningBolt> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
        this.life = 2;
        this.seed = this.f_19796_.m_188505_();
        this.flashes = this.f_19796_.m_188503_(3) + 1;
        this.m_20874_(true);
    }

    public JujutsuLightningEntity(LivingEntity owner, float damage) {
        this((EntityType<? extends LightningBolt>)((EntityType)JJKEntities.JUJUTSU_LIGHTNING.get()), owner.m_9236_());
        this.setOwner(owner);
        this.damage = damage;
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.WEATHER;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.life == 2 && this.m_9236_().f_46443_) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12090_, SoundSource.WEATHER, 2.0f, 0.8f + this.f_19796_.m_188501_() * 0.2f, false);
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12089_, SoundSource.WEATHER, 1.0f, 0.5f + this.f_19796_.m_188501_() * 0.2f, false);
        }
        --this.life;
        if (this.life < 0) {
            if (this.flashes == 0) {
                this.m_146870_();
            } else if (this.life < -this.f_19796_.m_188503_(10)) {
                --this.flashes;
                this.life = 1;
                this.seed = this.f_19796_.m_188505_();
            }
        }
        if (this.life >= 0) {
            if (!(this.m_9236_() instanceof ServerLevel)) {
                this.m_9236_().m_6580_(2);
            } else {
                List entities = this.m_9236_().m_6249_((Entity)this, new AABB(this.m_20185_() - 3.0, this.m_20186_() - 3.0, this.m_20189_() - 3.0, this.m_20185_() + 3.0, this.m_20186_() + 6.0 + 3.0, this.m_20189_() + 3.0), Entity::m_6084_);
                LivingEntity owner = this.getOwner();
                if (owner != null) {
                    ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                    for (Entity entity : entities) {
                        if (entity == owner && !cap.hasSelfHit()) continue;
                        entity.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, null), this.damage * cap.getAbilityPower());
                    }
                }
            }
        }
    }
}

