/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.util.RotationUtil;

public class ThrownChainProjectile
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> DATA_TIME = SynchedEntityData.m_135353_(ThrownChainProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.m_135353_(ThrownChainProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final int DURATION = 10;
    private int flightTime = 0;
    private boolean released;
    private boolean dealtDamage;
    private Entity pulled;

    public ThrownChainProjectile(EntityType<? extends AbstractArrow> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
    }

    public ThrownChainProjectile(LivingEntity pShooter, ItemStack stack) {
        super((EntityType)JJKEntities.THROWN_CHAIN.get(), pShooter, pShooter.m_9236_());
        Vec3 spawn = new Vec3(pShooter.m_20185_(), pShooter.m_20188_() - (double)(this.m_20206_() / 2.0f), pShooter.m_20189_()).m_82549_(RotationUtil.getTargetAdjustedLookAngle((Entity)pShooter));
        this.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
        this.f_19804_.m_135381_(DATA_ITEM, (Object)stack);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TIME, (Object)0);
        this.f_19804_.m_135372_(DATA_ITEM, (Object)ItemStack.f_41583_);
    }

    public int getTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_TIME);
    }

    public void setTime(int time) {
        this.f_19804_.m_135381_(DATA_TIME, (Object)time);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("time", this.getTime());
        pCompound.m_128379_("released", this.released);
        pCompound.m_128379_("dealt_damage", this.dealtDamage);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTime(pCompound.m_128451_("time"));
        this.released = pCompound.m_128471_("released");
        this.dealtDamage = pCompound.m_128471_("dealt_damage");
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    @Nullable
    protected EntityHitResult m_6351_(@NotNull Vec3 pStartVec, @NotNull Vec3 pEndVec) {
        return this.dealtDamage ? null : super.m_6351_(pStartVec, pEndVec);
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        super.m_8060_(pResult);
        if (this.dealtDamage) {
            return;
        }
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        if (!this.getStack().m_41619_()) {
            return;
        }
        this.pulled = owner;
        this.dealtDamage = true;
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        Entity target = pResult.m_82443_();
        Entity owner = this.m_19749_();
        if (this.getStack().m_41619_()) {
            if (owner != null && target.m_6094_()) {
                this.pulled = target;
                this.dealtDamage = true;
                this.m_20256_(Vec3.f_82478_);
            }
        } else {
            assert (owner != null);
            JJKDamageSources.JujutsuDamageSource source = JJKDamageSources.jujutsuAttack((LivingEntity)owner, (Ability)JJKAbilities.PUNCH.get());
            this.dealtDamage = true;
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            float DAMAGE = 8.5f * cap.getRealPower();
            if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
                DAMAGE = (float)((double)DAMAGE * 1.3);
            }
            SwordItem sword = (SwordItem)this.getStack().m_41720_();
            target.m_6469_((DamageSource)source, sword.m_43299_() + DAMAGE);
            this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        }
    }

    public void onRemovedFromWorld() {
        LivingEntity owner;
        super.onRemovedFromWorld();
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity && !(owner = (LivingEntity)entity).m_213877_() && !owner.m_21224_() && owner.m_21206_().m_41619_()) {
            owner.m_21008_(InteractionHand.OFF_HAND, this.getStack());
            return;
        }
        this.m_5552_(this.getStack(), 0.1f);
    }

    public void m_8119_() {
        this.setTime(this.getTime() + 1);
        Entity owner = this.m_19749_();
        float speedMult = 5.0f;
        if (owner == null) {
            this.m_146870_();
            return;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
            speedMult = 10.0f;
        }
        if (!(this.m_9236_().f_46443_ || owner != null && !owner.m_213877_() && owner.m_6084_() && this.f_36704_ <= 10)) {
            this.m_146870_();
        } else {
            if (!(owner instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)owner;
            if (this.released) {
                super.m_8119_();
                ++this.flightTime;
                if (this.flightTime > 40) {
                    this.m_146870_();
                    return;
                }
                if (this.f_36704_ > 4) {
                    this.dealtDamage = true;
                }
                if (this.dealtDamage && this.pulled != null) {
                    if (this.pulled == living) {
                        living.m_20256_(this.m_20182_().m_82546_(living.m_20182_()).m_82541_().m_82542_((double)(speedMult *= 0.6f), (double)speedMult, (double)speedMult));
                        if ((double)living.m_20270_((Entity)this) <= 1.0) {
                            this.m_146870_();
                            return;
                        }
                    } else {
                        this.m_146884_(this.pulled.m_20182_().m_82520_(0.0, (double)(this.pulled.m_20206_() / 2.0f), 0.0));
                        this.pulled.m_20256_(living.m_20182_().m_82546_(this.pulled.m_20182_()).m_82541_().m_82542_((double)(speedMult *= 0.6f), (double)speedMult, (double)speedMult));
                        if ((double)this.pulled.m_20270_((Entity)living) <= 1.0) {
                            this.m_146870_();
                            return;
                        }
                    }
                    this.pulled.f_19864_ = true;
                }
            } else {
                double angle = Math.toRadians(this.getTime() * this.getTime());
                double radius = 2.0;
                float yaw = (float)Math.toRadians(living.m_146908_());
                float pitch = (float)Math.toRadians(90.0);
                Vec3 offset = new Vec3(Math.cos(angle) * radius, 0.0, Math.sin(angle) * radius).m_82496_(pitch).m_82524_(-yaw);
                Vec3 position = living.m_20182_().m_82549_(RotationUtil.getTargetAdjustedLookAngle((Entity)living)).m_82549_(offset);
                if (living.m_6117_()) {
                    this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
                    this.m_19915_((float)Math.toDegrees(Math.atan2(offset.f_82479_, offset.f_82481_)), -((float)Math.toDegrees(Math.asin(offset.f_82480_ / offset.m_82553_()))));
                    if (this.f_19796_.m_188503_(5) == 0) {
                        this.m_216990_(SoundEvents.f_11745_);
                    }
                } else {
                    Vec3 spawn = new Vec3(living.m_20185_(), living.m_20188_() - (double)(this.m_20206_() / 2.0f), living.m_20189_()).m_82549_(RotationUtil.getTargetAdjustedLookAngle((Entity)living));
                    this.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
                    this.m_19915_(-RotationUtil.getTargetAdjustedYRot((Entity)living), RotationUtil.getTargetAdjustedXRot((Entity)living));
                    this.m_20256_(RotationUtil.getTargetAdjustedLookAngle((Entity)living).m_82490_(new Vec3(this.f_19790_, this.f_19791_, this.f_19792_).m_82546_(position).m_82553_() * (double)speedMult));
                    this.released = true;
                    this.flightTime = 0;
                }
            }
        }
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    protected float m_6882_() {
        return 0.99f;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public ItemStack getStack() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ITEM);
    }
}

