/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.sorcerer.base;

import java.util.Arrays;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.entity.ai.goal.NearestAttackableCurseGoal;
import radon.jujutsu_kaisen.entity.ai.goal.NearestAttackableShikigamiGoal;
import radon.jujutsu_kaisen.entity.ai.goal.NearestAttackableSorcererGoal;
import radon.jujutsu_kaisen.entity.ai.goal.SorcererGoal;
import radon.jujutsu_kaisen.entity.ai.goal.WaterWalkingFloatGoal;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.SorcererUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class SorcererEntity
extends PathfinderMob
implements GeoEntity,
ISorcerer {
    private static final int RARITY = 6;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    protected SorcererEntity(EntityType<? extends PathfinderMob> pType, Level pLevel) {
        super(pType, pLevel);
        Arrays.fill(this.f_21348_, 1.0f);
        Arrays.fill(this.f_21347_, 1.0f);
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return true;
    }

    @Override
    public boolean canJump() {
        return true;
    }

    @Override
    public boolean canChant() {
        return true;
    }

    protected abstract boolean isCustom();

    protected boolean canFly() {
        return false;
    }

    protected boolean targetsCurses() {
        return true;
    }

    protected boolean targetsSorcerers() {
        return false;
    }

    protected boolean targetsShikigami() {
        return false;
    }

    private void createGoals() {
        int target = 1;
        int goal = 1;
        this.f_21345_.m_25352_(goal++, (Goal)new WaterWalkingFloatGoal(this));
        if (this.hasMeleeAttack()) {
            this.f_21345_.m_25352_(goal++, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.75, true));
        }
        this.f_21345_.m_25352_(goal++, (Goal)new SorcererGoal(this));
        this.f_21345_.m_25352_(goal, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(target++, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        if (this.targetsSorcerers()) {
            this.f_21346_.m_25352_(target++, (Goal)new NearestAttackableSorcererGoal((Mob)this, true));
        }
        if (this.targetsCurses()) {
            this.f_21346_.m_25352_(target, (Goal)new NearestAttackableCurseGoal((Mob)this, true));
        }
        if (this.targetsShikigami()) {
            this.f_21346_.m_25352_(target, (Goal)new NearestAttackableShikigamiGoal((Mob)this, true));
        }
    }

    public boolean m_21532_() {
        return this.getGrade().ordinal() > SorcererGrade.GRADE_1.ordinal();
    }

    protected void m_6475_(@NotNull DamageSource pDamageSource, float pDamageAmount) {
        LivingEntity attacker;
        super.m_6475_(pDamageSource, pDamageAmount);
        Entity entity = pDamageSource.m_7639_();
        if (entity instanceof LivingEntity && this.m_6779_(attacker = (LivingEntity)entity) && attacker != this) {
            this.m_6710_(attacker);
        }
    }

    private boolean isInVillage() {
        HolderSet.Named structures = (HolderSet.Named)this.m_9236_().m_9598_().m_175515_(Registries.f_256944_).m_203431_(StructureTags.f_215889_).orElseThrow();
        boolean success = false;
        for (Holder holder : structures) {
            if (!((ServerLevel)this.m_9236_()).m_215010_().m_220524_(this.m_20183_(), (Structure)holder.get()).m_73603_()) continue;
            success = true;
            break;
        }
        return success;
    }

    public boolean m_5545_(@NotNull LevelAccessor pLevel, @NotNull MobSpawnType pSpawnReason) {
        if (pSpawnReason == MobSpawnType.NATURAL || pSpawnReason == MobSpawnType.CHUNK_GENERATION) {
            if (this.f_19796_.m_188503_(Mth.m_14143_((float)(6.0f * SorcererUtil.getPower(this.getExperience())))) != 0) {
                return false;
            }
            if (!this.isInVillage()) {
                return false;
            }
        }
        if (this.getGrade().ordinal() >= SorcererGrade.GRADE_1.ordinal() && !pLevel.m_45976_(this.getClass(), AABB.m_165882_((Vec3)this.m_20182_(), (double)128.0, (double)64.0, (double)128.0)).isEmpty()) {
            return false;
        }
        if (!pLevel.m_45976_(SorcererEntity.class, AABB.m_165882_((Vec3)this.m_20182_(), (double)16.0, (double)8.0, (double)16.0)).isEmpty()) {
            return false;
        }
        return super.m_5545_(pLevel, pSpawnReason);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        LivingEntity target = this.m_5448_();
        GroundPathNavigation navigation = new GroundPathNavigation((Mob)this, pLevel);
        navigation.m_26477_(false);
        navigation.m_7008_(false);
        navigation.m_148214_(true);
        return navigation;
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
    }

    protected void m_8024_() {
        super.m_8024_();
        LivingEntity passenger = this.m_6688_();
        if (this.m_5448_() != null) {
            ISorcererData cap = (ISorcererData)this.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (!cap.hasBurnout()) {
                this.f_21342_.m_6849_(this.m_5448_().m_20185_(), this.m_5448_().m_20186_(), this.m_5448_().m_20189_(), (double)0.9f);
            }
            if (HelperMethods.RANDOM.m_188503_(5) == 0 || cap.hasBurnout() && HelperMethods.RANDOM.m_188503_(3) == 0) {
                this.f_21342_.m_6849_(this.m_5448_().m_20185_() * -1.5, this.m_5448_().m_20186_() * (double)-1.1f, this.m_5448_().m_20189_() * (double)-1.1f, (double)1.4f);
            }
        }
        if (passenger != null) {
            this.m_6858_(new Vec3((double)passenger.f_20900_, (double)passenger.f_20901_, (double)passenger.f_20902_).m_82556_() > 0.01);
        } else {
            this.m_6858_(this.m_20184_().m_82556_() > 0.01 && this.f_21342_.m_24999_() > 1.0);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22266_(Attributes.f_22281_).m_22268_(Attributes.f_22277_, 96.0);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.isCustom()) {
            this.createGoals();
        }
        this.getCapability(SorcererDataHandler.INSTANCE).ifPresent(this::init);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

